/*
 * Decompiled with CFR 0.152.
 */
package com.robot.transform;

import com.robot.transform.util.TransformUtil;
import javax.annotation.Resource;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.support.GenericConversionService;

@Aspect
public class TranslatorAspect {
    private static final Logger log = LoggerFactory.getLogger(TranslatorAspect.class);
    @Resource
    private GenericConversionService genericConversionService;

    @AfterReturning(pointcut="@annotation(com.robot.transform.annotation.Transform)", returning="returnValue")
    public void doAfter(Object returnValue) {
        Object result = this.genericConversionService.convert(returnValue, Object.class);
        TransformUtil.transform(result);
    }
}

