/*
 * Decompiled with CFR 0.152.
 */
package com.robot.transform.component;

import com.robot.transform.component.DictBean;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Dict<T> {
    public static <T> String getTextByCode(Class<? extends Dict<T>> clazz, T code) {
        return Stream.of(clazz.getEnumConstants()).filter(e -> e.getCode().equals(code)).map(Dict::getText).findAny().orElse(null);
    }

    public static <T> T getCodeByText(Class<? extends Dict<T>> clazz, String text) {
        return Stream.of(clazz.getEnumConstants()).filter(e -> e.getText().equals(text)).map(Dict::getCode).findAny().orElse(null);
    }

    public static <T, R extends Dict<T>> R getByCode(Class<? extends Dict<T>> clazz, T code) {
        return (R)((Dict)Stream.of(clazz.getEnumConstants()).filter(e -> e.getCode().equals(code)).map(v -> v).findAny().orElse(null));
    }

    @SafeVarargs
    public static <T, E extends Dict<T>> List<Dict<T>> getItems(E ... enums) {
        return Stream.of(enums).map(DictPool::getDict).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T, E extends Dict<T>> List<Dict<T>> getItemsExclude(E ... exclude) {
        Class<?> clazz = exclude.getClass().getComponentType();
        Dict[] allEnum = (Dict[])clazz.getEnumConstants();
        List excludeList = Arrays.asList(exclude);
        return Stream.of(allEnum).filter(e -> !excludeList.contains(e)).map(DictPool::getDict).collect(Collectors.toList());
    }

    public static <T> List<Dict<T>> getAll(Class<? extends Dict<T>> clazz) {
        Map fieldCache = Arrays.stream(clazz.getDeclaredFields()).filter(Field::isEnumConstant).collect(Collectors.toMap(Field::getName, Function.identity()));
        Dict<T>[] allEnum = clazz.getEnumConstants();
        return Stream.of(allEnum).filter(e -> !((Field)fieldCache.get(((Enum)((Object)e)).name())).isAnnotationPresent(Deprecated.class)).map(DictPool::getDict).collect(Collectors.toList());
    }

    default public void init(T code, String text) {
        DictPool.putDict(this, code, text);
    }

    default public T getCode() {
        return DictPool.getDict(this).getCode();
    }

    default public String getText() {
        return DictPool.getDict(this).getText();
    }

    public static class DictPool {
        private static final Map<Dict, DictBean> DICT_MAP = new ConcurrentHashMap<Dict, DictBean>();
        private static final Map<String, Class<? extends Dict>> DICT_NAME_CLASS_MAP = new ConcurrentHashMap<String, Class<? extends Dict>>();

        static <T> void putDict(Dict<T> dict, T code, String text) {
            DICT_NAME_CLASS_MAP.put(dict.getClass().getName(), dict.getClass());
            DICT_MAP.put(dict, new DictBean<T>(code, text));
        }

        public static List<Dict<Object>> getDict(String dictName) {
            Class<? extends Dict> aClass = DICT_NAME_CLASS_MAP.get(dictName);
            return Dict.getAll(aClass);
        }

        static <K extends Dict<T>, T> DictBean<T> getDict(K dict) {
            return DICT_MAP.get(dict);
        }
    }
}

