/*
 * Decompiled with CFR 0.152.
 */
package com.robot.transform.util;

import com.robot.transform.annotation.Transform;
import com.robot.transform.transformer.Transformer;
import com.robot.transform.util.LambdaUtil;
import com.robot.transform.util.SpringContextUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public final class TransformUtil {
    private static final Logger log = LoggerFactory.getLogger(TransformUtil.class);
    private static final Map<Field, Transform> ANNOTATION_CACHE = new ConcurrentHashMap<Field, Transform>(1000);

    public static void transform(Object object) {
        if (object == null) {
            return;
        }
        log.debug("\u5f85\u8f6c\u6362\u5bf9\u8c61\u7c7b\u578b{}", (Object)object.getClass().getSimpleName());
        Set<Object> collection = object instanceof Collection ? (Set<Object>)object : Collections.singleton(object);
        collection.forEach(bean -> {
            Field[] declaredFields = bean.getClass().getDeclaredFields();
            Arrays.stream(declaredFields).filter(field -> field.getType() == String.class && AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, Transform.class)).forEach(field -> TransformUtil.transformField(bean, field));
            Arrays.stream(declaredFields).filter(field -> field.getType() != String.class && field.isAnnotationPresent(Transform.class)).forEach(field -> {
                Object propertyValue = LambdaUtil.sure(() -> TransformUtil.readMethodInvoke(bean, field.getName()));
                TransformUtil.transform(propertyValue);
            });
        });
    }

    private static void transformField(Object bean, Field field) {
        Transform transformAnnotation = TransformUtil.getTransformAnnotation(field);
        String originalFieldName = TransformUtil.getOriginalFieldName(bean, field, transformAnnotation);
        Object originalFieldValue = LambdaUtil.sure(() -> TransformUtil.readMethodInvoke(bean, originalFieldName));
        if (originalFieldValue == null) {
            return;
        }
        Class<? extends Transformer> transformerClass = transformAnnotation.transformer();
        Assert.isTrue((transformerClass != null ? 1 : 0) != 0, (String)("\u6ce8\u89e3\u914d\u7f6e\u6709\u8bef\uff0c" + transformAnnotation.getClass().getSimpleName() + "\u7684transformer\u672a\u914d\u7f6e\u5177\u4f53\u5b9e\u73b0\u7c7b"));
        Transformer transformer = SpringContextUtil.getBean(transformerClass);
        Annotation annotation = TransformUtil.getAnnotationOfTransformer(transformer, field, transformAnnotation);
        String result = transformer.transform(originalFieldValue, annotation);
        LambdaUtil.sure(() -> TransformUtil.writeMethodInvoke(bean, field.getName(), String.class, result));
    }

    @Nullable
    private static Annotation getAnnotationOfTransformer(Transformer<Object, Annotation> transformer, Field field, Transform transformAnnotation) {
        Class[] genericTypes = GenericTypeResolver.resolveTypeArguments(transformer.getClass(), Transformer.class);
        Assert.isTrue((genericTypes != null ? 1 : 0) != 0, (String)("\u8f6c\u6362\u9519\u8bef\uff01\u5b9e\u73b0Transform\u63a5\u53e3\u5fc5\u987b\u6307\u5b9a\u6cdb\u578b\uff1a" + transformer.getClass().getSimpleName()));
        Class transformerAnnotationType = genericTypes[1];
        Transform annotation = transformerAnnotationType == Transform.class ? transformAnnotation : AnnotationUtils.getAnnotation((AnnotatedElement)field, (Class)transformerAnnotationType);
        TransformUtil.checkAnnotationOfTransformer(annotation, field, transformerAnnotationType);
        return annotation;
    }

    private static void checkAnnotationOfTransformer(Annotation annotation, Field field, Class<?> transformerAnnotationType) {
        if (annotation == null) {
            String beanName = field.getDeclaringClass().getSimpleName();
            String fieldName = field.getName();
            String annotationName = transformerAnnotationType.getSimpleName();
            if (transformerAnnotationType.getDeclaredMethods().length > 1) {
                throw new IllegalArgumentException(beanName + "\u5c5e\u6027" + fieldName + "\u4e0a\u7684\u6ce8\u89e3\u914d\u7f6e\u9519\u8bef\uff0c\u7f3a\u5c11\u6ce8\u89e3@" + annotationName);
            }
            log.warn(MessageFormat.format("{0}\u7c7b\u7684\u5c5e\u6027{1}\u4e0a\u7684\u300c@Transform\u300d\u6ce8\u89e3\u914d\u7f6e\u65b9\u5f0f\u5df2\u8fc7\u65f6\uff0c\u5efa\u8bae\u66ff\u6362\u4e3a\u65b0\u6ce8\u89e3\u300c@{2}\u300d", beanName, fieldName, annotationName));
        }
    }

    private static Transform getTransformAnnotation(Field field) {
        return ANNOTATION_CACHE.computeIfAbsent(field, k -> (Transform)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, Transform.class));
    }

    private static String getOriginalFieldName(Object bean, Field field, Transform transform) {
        if (!transform.from().isEmpty()) {
            return transform.from();
        }
        String transformFieldName = field.getName();
        String possibleNameA = StringUtils.replace((String)transformFieldName, (String)"Name", (String)"");
        String possibleNameB = StringUtils.replace((String)transformFieldName, (String)"Name", (String)"Id");
        String possibleNameC = StringUtils.replace((String)transformFieldName, (String)"Name", (String)"Code");
        List<String> nameList = Arrays.asList(possibleNameA, possibleNameB, possibleNameC);
        for (Field beanField : bean.getClass().getDeclaredFields()) {
            String fieldName = beanField.getName();
            if (!nameList.contains(fieldName)) continue;
            TransformUtil.updateAnnotationProxy(transform, "from", fieldName);
            return fieldName;
        }
        throw new IllegalArgumentException("\u8f6c\u6362\u5f02\u5e38\uff1a\u65e0\u6cd5\u81ea\u52a8\u63a8\u65ad" + transformFieldName + "\u7684\u539f\u59cb\u5b57\u6bb5\u540d\uff0c\u8bf7\u4f7f\u7528\u6ce8\u89e3@Transform\u7684from\u5c5e\u6027\u6307\u5b9a\u88ab\u8f6c\u6362\u7684\u5b57\u6bb5");
    }

    private static void updateAnnotationProxy(Annotation annotation, String fieldName, Object value) {
        InvocationHandler h = Proxy.getInvocationHandler(annotation);
        Field field = LambdaUtil.sure(() -> h.getClass().getDeclaredField("valueCache"));
        field.setAccessible(true);
        Map memberValues = (Map)LambdaUtil.sure(() -> field.get(h));
        memberValues.put(fieldName, value);
    }

    public static Object readMethodInvoke(Object bean, String fieldName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = bean.getClass().getDeclaredMethod("get" + TransformUtil.capitalize(fieldName), new Class[0]);
        return method.invoke(bean, new Object[0]);
    }

    public static <T> void writeMethodInvoke(Object bean, String fieldName, Class<T> parameterType, T parameter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = bean.getClass().getDeclaredMethod("set" + TransformUtil.capitalize(fieldName), parameterType);
        method.invoke(bean, parameter);
    }

    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private TransformUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

