/*
 * Decompiled with CFR 0.152.
 */
package io.github.lvdkooi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Conditional<S, T> {
    private final S value;
    private final List<ConditionalAction<S, T>> conditionalActions;

    private Conditional(S value, List<ConditionalAction<S, T>> actions) {
        this.value = value;
        this.conditionalActions = actions;
    }

    public static <S> Conditional<S, S> of(S value) {
        return new Conditional(value, Collections.emptyList());
    }

    private static <S, T> Conditional<S, T> empty() {
        return new Conditional<Object, T>(null, Collections.emptyList());
    }

    public static <S, U> ConditionalAction<S, U> applyIf(Predicate<S> condition, Function<S, U> function) {
        return new ConditionalAction<S, U>(condition, function);
    }

    @SafeVarargs
    public final <U> Conditional<S, U> firstMatching(ConditionalAction<S, U> ... actions) {
        List<ConditionalAction<S, T>> actionsAsList = Arrays.stream(actions).toList();
        return new Conditional<S, T>(this.value, actionsAsList);
    }

    public <U> Conditional<S, U> map(Function<T, U> mapFunction) {
        Objects.requireNonNull(mapFunction);
        List<ConditionalAction<S, T>> updatedConditionalActions = this.conditionalActions.stream().map((? super T condAction) -> condAction.and(mapFunction)).toList();
        return new Conditional<S, T>(this.value, updatedConditionalActions);
    }

    public <U> Conditional<T, U> flatMap(Function<T, Conditional<T, U>> flatMapFunction) {
        return this.map(flatMapFunction).orElseGet(Conditional::empty);
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        return (T)Optional.ofNullable(this.value).flatMap(this::findMatchingFunction).orElse(obj -> supplier.get()).apply(this.value);
    }

    public T orElse(T defaultValue) {
        return (T)Optional.ofNullable(this.value).flatMap(this::findMatchingFunction).orElse(obj -> defaultValue).apply(this.value);
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        Objects.requireNonNull(exceptionSupplier);
        return (T)((Function)Optional.ofNullable(this.value).flatMap(this::findMatchingFunction).orElseThrow(exceptionSupplier)).apply(this.value);
    }

    private Optional<Function<S, T>> findMatchingFunction(S value) {
        return this.conditionalActions.stream().filter(entry -> entry.condition().test(value)).findFirst().map(ConditionalAction::action);
    }

    public record ConditionalAction<S, T>(Predicate<S> condition, Function<S, T> action) {
        public ConditionalAction {
            Objects.requireNonNull(condition);
            Objects.requireNonNull(action);
        }

        public <U> ConditionalAction<S, U> and(Function<T, U> extraAction) {
            return new ConditionalAction<S, U>(this.condition, this.action.andThen(extraAction));
        }
    }
}

