/*
 * Decompiled with CFR 0.152.
 */
package io.github.lvyahui8.spring.autoconfigure;

import io.github.lvyahui8.spring.aggregate.config.RuntimeSettings;
import io.github.lvyahui8.spring.aggregate.facade.DataBeanAggregateQueryFacade;
import io.github.lvyahui8.spring.aggregate.facade.impl.DataBeanAggregateQueryFacadeImpl;
import io.github.lvyahui8.spring.aggregate.interceptor.AggregateQueryInterceptor;
import io.github.lvyahui8.spring.aggregate.interceptor.AggregateQueryInterceptorChain;
import io.github.lvyahui8.spring.aggregate.interceptor.impl.AggregateQueryInterceptorChainImpl;
import io.github.lvyahui8.spring.aggregate.model.DataConsumeDefinition;
import io.github.lvyahui8.spring.aggregate.model.DataProvideDefinition;
import io.github.lvyahui8.spring.aggregate.repository.DataProviderRepository;
import io.github.lvyahui8.spring.aggregate.repository.impl.DataProviderRepositoryImpl;
import io.github.lvyahui8.spring.aggregate.service.DataBeanAggregateService;
import io.github.lvyahui8.spring.aggregate.service.impl.DataBeanAggregateServiceImpl;
import io.github.lvyahui8.spring.aggregate.util.DefinitionUtils;
import io.github.lvyahui8.spring.annotation.DataProvider;
import io.github.lvyahui8.spring.autoconfigure.BeanAggregateProperties;
import io.github.lvyahui8.spring.facade.FacadeInitializer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={BeanAggregateProperties.class})
public class BeanAggregateAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BeanAggregateAutoConfiguration.class);
    private ApplicationContext applicationContext;
    @Autowired
    private BeanAggregateProperties properties;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataBeanAggregateQueryFacade dataBeanAggregateQueryFacade(@Qualifier(value="dataProviderRepository") DataProviderRepository dataProviderRepository) {
        DataBeanAggregateQueryFacadeImpl facade = new DataBeanAggregateQueryFacadeImpl(this.dataBeanAggregateQueryService(dataProviderRepository));
        FacadeInitializer.initFacade((DataBeanAggregateQueryFacade)facade);
        return facade;
    }

    private void checkCycle(Map<String, Set<String>> graphAdjMap) {
        HashMap<String, Integer> visitStatusMap = new HashMap<String, Integer>(graphAdjMap.size() * 2);
        for (Map.Entry<String, Set<String>> item : graphAdjMap.entrySet()) {
            if (visitStatusMap.containsKey(item.getKey())) continue;
            this.dfs(graphAdjMap, visitStatusMap, item.getKey());
        }
    }

    private void dfs(Map<String, Set<String>> graphAdjMap, Map<String, Integer> visitStatusMap, String node) {
        if (visitStatusMap.containsKey(node)) {
            if (visitStatusMap.get(node) == 1) {
                ArrayList<String> relatedNodes = new ArrayList<String>();
                for (Map.Entry<String, Integer> item : visitStatusMap.entrySet()) {
                    if (item.getValue() != 1) continue;
                    relatedNodes.add(item.getKey());
                }
                throw new IllegalStateException("There are loops in the dependency graph. Related nodes:" + StringUtils.join((Object[])new List[]{relatedNodes}));
            }
            return;
        }
        visitStatusMap.put(node, 1);
        log.info("visited:{}", (Object)node);
        for (String relateNode : graphAdjMap.get(node)) {
            this.dfs(graphAdjMap, visitStatusMap, relateNode);
        }
        visitStatusMap.put(node, 2);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataBeanAggregateService dataBeanAggregateQueryService(@Qualifier(value="dataProviderRepository") DataProviderRepository dataProviderRepository) {
        if (this.properties.getBasePackages() != null) {
            HashMap<String, Set<String>> provideDependMap = new HashMap<String, Set<String>>(64);
            for (String basePackage : this.properties.getBasePackages()) {
                Reflections reflections = new Reflections(basePackage, new Scanner[]{new MethodAnnotationsScanner()});
                Set providerMethods = reflections.getMethodsAnnotatedWith(DataProvider.class);
                for (Method method : providerMethods) {
                    DataProvider beanProvider = (DataProvider)AnnotationUtils.findAnnotation((Method)method, DataProvider.class);
                    String dataId = beanProvider.id();
                    Assert.isTrue((boolean)Modifier.isPublic(method.getModifiers()), (String)"data provider method must be public");
                    Assert.isTrue((!StringUtils.isEmpty((CharSequence)dataId) ? 1 : 0) != 0, (String)"data id must be not null!");
                    DataProvideDefinition provider = DefinitionUtils.getProvideDefinition((Method)method);
                    provider.setId(dataId);
                    provider.setIdempotent(beanProvider.idempotent());
                    provider.setTimeout(Long.valueOf(beanProvider.timeout() > 0L ? beanProvider.timeout() : this.properties.getDefaultTimeout().longValue()));
                    Assert.isTrue((!dataProviderRepository.contains(dataId) ? 1 : 0) != 0, (String)("Data providers with the same name are not allowed. dataId: " + dataId));
                    provideDependMap.put(dataId, provider.getDepends().stream().map(DataConsumeDefinition::getId).collect(Collectors.toSet()));
                    dataProviderRepository.put(provider);
                }
            }
            this.checkCycle(provideDependMap);
        }
        DataBeanAggregateServiceImpl service = new DataBeanAggregateServiceImpl();
        RuntimeSettings runtimeSettings = new RuntimeSettings();
        runtimeSettings.setIgnoreException(this.properties.isIgnoreException());
        runtimeSettings.setTimeout(this.properties.getDefaultTimeout());
        service.setRepository(dataProviderRepository);
        service.setRuntimeSettings(runtimeSettings);
        service.setExecutorService(this.aggregateExecutorService());
        service.setInterceptorChain(this.aggregateQueryInterceptorChain());
        service.setTaskWrapperClazz(this.properties.getTaskWrapperClass());
        service.setApplicationContext(this.applicationContext);
        return service;
    }

    @Bean(name={"aggregateExecutorService"})
    @ConditionalOnMissingBean(name={"aggregateExecutorService"}, value={ExecutorService.class})
    public ExecutorService aggregateExecutorService() {
        return new ThreadPoolExecutor(this.properties.getThreadNumber(), this.properties.getThreadNumber(), 2L, TimeUnit.HOURS, new LinkedBlockingDeque<Runnable>(this.properties.getQueueSize()), (ThreadFactory)new CustomizableThreadFactory(this.properties.getThreadPrefix()));
    }

    @Bean(name={"dataProviderRepository"})
    @ConditionalOnMissingBean(value={DataProviderRepository.class})
    public DataProviderRepository dataProviderRepository() {
        return new DataProviderRepositoryImpl();
    }

    @Bean(name={"aggregateQueryInterceptorChain"})
    @ConditionalOnMissingBean(value={AggregateQueryInterceptorChain.class})
    public AggregateQueryInterceptorChain aggregateQueryInterceptorChain() {
        Map interceptorMap = this.applicationContext.getBeansOfType(AggregateQueryInterceptor.class);
        AggregateQueryInterceptorChainImpl interceptorChain = new AggregateQueryInterceptorChainImpl();
        if (interceptorMap != null && !interceptorMap.isEmpty()) {
            ArrayList interceptors = new ArrayList(interceptorMap.values());
            interceptors.sort(new Comparator<AggregateQueryInterceptor>(){

                @Override
                public int compare(AggregateQueryInterceptor o1, AggregateQueryInterceptor o2) {
                    Order order1 = o1.getClass().getAnnotation(Order.class);
                    Order order2 = o2.getClass().getAnnotation(Order.class);
                    int oi1 = order1 == null ? Integer.MAX_VALUE : order1.value();
                    int oi2 = order2 == null ? Integer.MAX_VALUE : order2.value();
                    return oi1 - oi2;
                }
            });
            for (AggregateQueryInterceptor interceptor : interceptors) {
                interceptorChain.addInterceptor(interceptor);
            }
        }
        return interceptorChain;
    }
}

