/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.common;

public class Preconditions {
    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object message) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(message));
        }
    }

    public static void checkArgument(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    public static <T> T checkNotNull(T instance) {
        if (instance == null) {
            throw new NullPointerException();
        }
        return instance;
    }

    public static <T> T checkNotNull(T reference, Object message) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(message));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String format, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(String.format(format, args));
        }
        return reference;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object message) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(message));
        }
    }

    public static void checkState(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(format, args));
        }
    }
}

