/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.common.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class BasicThreadFactory
implements ThreadFactory {
    private final AtomicLong counter = new AtomicLong();
    private final Boolean daemon;
    private final String format;
    private final Integer priority;

    private BasicThreadFactory(Boolean daemon, String format, Integer priority) {
        this.daemon = daemon;
        this.format = format;
        this.priority = priority;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        if (this.daemon != null) {
            thread.setDaemon(this.daemon);
        }
        if (this.format != null) {
            thread.setName(String.format(this.format, this.counter.incrementAndGet()));
        }
        if (this.priority != null) {
            thread.setPriority(this.priority);
        }
        return thread;
    }

    public static final class Builder {
        private Boolean daemon;
        private String format;
        private Integer priority;

        private Builder() {
        }

        public BasicThreadFactory build() {
            return new BasicThreadFactory(this.daemon, this.format, this.priority);
        }

        public Builder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }
    }
}

