/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.common.task;

import io.github.lxgaming.common.Preconditions;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    private long delay;
    private long interval;
    private Type type;
    private volatile Exception exception;
    private volatile ScheduledFuture<?> scheduledFuture;

    public abstract boolean prepare();

    public abstract void execute() throws Exception;

    @Override
    public final void run() {
        try {
            this.execute();
        }
        catch (Exception ex) {
            LOGGER.error("Encountered an error while executing {}", (Object)this.getClass().getName(), (Object)ex);
            this.exception(ex);
            this.getScheduledFuture().cancel(false);
        }
    }

    public boolean await() {
        try {
            if (this.getScheduledFuture() == null) {
                return false;
            }
            this.getScheduledFuture().get();
            return this.getException() == null;
        }
        catch (Exception ex) {
            if (this.getException() == null) {
                this.exception(ex);
            }
            return false;
        }
    }

    public boolean await(long timeout, TimeUnit unit) {
        try {
            if (this.getScheduledFuture() == null) {
                return false;
            }
            this.getScheduledFuture().get(timeout, unit);
            return this.getException() == null;
        }
        catch (Exception ex) {
            if (this.getException() == null) {
                this.exception(ex);
            }
            return false;
        }
    }

    public final void schedule(ScheduledExecutorService scheduledExecutorService) throws Exception {
        Preconditions.checkNotNull(this.type, "type");
        this.exception(null);
        if (this.type == Type.DEFAULT) {
            this.scheduledFuture(scheduledExecutorService.schedule(this, this.delay, TimeUnit.MILLISECONDS));
        } else if (this.type == Type.FIXED_DELAY) {
            this.scheduledFuture(scheduledExecutorService.scheduleWithFixedDelay(this, this.delay, this.interval, TimeUnit.MILLISECONDS));
        } else if (this.type == Type.FIXED_RATE) {
            this.scheduledFuture(scheduledExecutorService.scheduleAtFixedRate(this, this.delay, this.interval, TimeUnit.MILLISECONDS));
        }
    }

    public final long getDelay() {
        return this.delay;
    }

    protected final void delay(long delay, TimeUnit unit) {
        this.delay = unit.toMillis(delay);
    }

    public final long getInterval() {
        return this.interval;
    }

    protected final void interval(long interval, TimeUnit unit) {
        this.interval = unit.toMillis(interval);
    }

    public final Type getType() {
        return this.type;
    }

    protected final void type(Type type) {
        this.type = type;
    }

    public final Exception getException() {
        return this.exception;
    }

    protected final void exception(Exception exception) {
        this.exception = exception;
    }

    public final ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    protected final void scheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public static enum Type {
        DEFAULT("Default"),
        FIXED_DELAY("Fixed Delay"),
        FIXED_RATE("Fixed Rate");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

