/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.base.metainfo;

import io.github.mmm.base.lang.ValueType;
import io.github.mmm.base.metainfo.MetaInfos;
import io.github.mmm.base.metainfo.impl.AppConfigHolder;
import io.github.mmm.base.metainfo.impl.MetaInfoEmpty;
import io.github.mmm.base.number.NumberType;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public interface MetaInfo
extends Iterable<String> {
    default public String get(String key) {
        return this.get(true, key);
    }

    default public String getRequired(String key) {
        return this.get(true, true, key);
    }

    default public String get(String key, String defaultValue) {
        return this.get(true, key, defaultValue);
    }

    default public String get(boolean inherit, String key, String defaultValue) {
        String value = this.get(inherit, key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String get(boolean var1, String var2);

    public String get(boolean var1, boolean var2, String var3);

    public <T> T getGeneric(boolean var1, boolean var2, String var3, ValueType<T> var4);

    default public Integer getAsInteger(String key) {
        return this.getAsInteger(true, false, key);
    }

    default public int getAsIntegerRequired(String key) {
        return this.getAsInteger(true, true, key);
    }

    default public Integer getAsInteger(boolean inherit, boolean required, String key) {
        return (Integer)this.getGeneric(inherit, required, key, (ValueType)NumberType.INTEGER);
    }

    default public int getAsInteger(String key, int defaultValue) {
        return this.getAsInteger(true, key, defaultValue);
    }

    default public int getAsInteger(boolean inherit, String key, int defaultValue) {
        Integer value = this.getAsInteger(inherit, false, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    default public Long getAsLong(String key) {
        return this.getAsLong(true, false, key);
    }

    default public long getAsLongRequired(String key) {
        return this.getAsLong(true, true, key);
    }

    default public Long getAsLong(boolean inherit, boolean required, String key) {
        return (Long)this.getGeneric(inherit, required, key, (ValueType)NumberType.LONG);
    }

    default public long getAsLong(String key, long defaultValue) {
        return this.getAsLong(true, key, defaultValue);
    }

    default public long getAsLong(boolean inherit, String key, long defaultValue) {
        Long value = this.getAsLong(inherit, false, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    default public Boolean getAsBoolean(String key) {
        return this.getAsBoolean(true, false, key);
    }

    default public boolean getAsBooleanRequired(String key) {
        return this.getAsBoolean(true, true, key);
    }

    default public Boolean getAsBoolean(boolean inherit, boolean required, String key) {
        return (Boolean)this.getGeneric(inherit, required, key, ValueType.BOOLEAN);
    }

    default public boolean getAsBoolean(String key, boolean defaultValue) {
        return this.getAsBoolean(true, key, defaultValue);
    }

    default public boolean getAsBoolean(boolean inherit, String key, boolean defaultValue) {
        Boolean value = this.getAsBoolean(inherit, false, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int size();

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public MetaInfo getParent() {
        return null;
    }

    default public String getKeyPrefix() {
        return "";
    }

    public MetaInfo with(String var1, String var2);

    default public MetaInfo with(Map<String, String> map) {
        return this.with(map, "");
    }

    public MetaInfo with(Map<String, String> var1, String var2);

    default public MetaInfo with(Properties properties) {
        return this.with(properties, "");
    }

    public MetaInfo with(Properties var1, String var2);

    default public MetaInfo with(AnnotatedElement annotatedElement) {
        MetaInfos metaInfos = annotatedElement.getAnnotation(MetaInfos.class);
        if (metaInfos == null) {
            return this;
        }
        return this.with(metaInfos);
    }

    public MetaInfo with(MetaInfos var1);

    public MetaInfo with(String var1);

    default public Properties asProperties() {
        Properties properties = new Properties();
        for (String key : this) {
            properties.setProperty(key, this.get(key));
        }
        return properties;
    }

    default public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.size());
        for (String key : this) {
            map.put(key, this.get(key));
        }
        return map;
    }

    public static MetaInfo empty() {
        return MetaInfoEmpty.INSTANCE;
    }

    public static MetaInfo config() {
        return AppConfigHolder.CONFIG;
    }
}

