/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.base.metainfo.impl;

import io.github.mmm.base.exception.ObjectMismatchException;
import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.base.lang.ValueType;
import io.github.mmm.base.metainfo.MetaInfo;
import io.github.mmm.base.metainfo.MetaInfos;
import io.github.mmm.base.metainfo.impl.MetaInfoInherited;
import io.github.mmm.base.metainfo.impl.MetaInfoMap;
import io.github.mmm.base.metainfo.impl.MetaInfoProperties;
import io.github.mmm.base.metainfo.impl.MetaInfoSingle;
import io.github.mmm.base.metainfo.impl.MetaInfoValue;
import io.github.mmm.base.metainfo.impl.MetaInfoValues;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public abstract class AbstractMetaInfo
implements MetaInfo {
    @Override
    public AbstractMetaInfo getParent() {
        return null;
    }

    protected MetaInfoInherited asParent() {
        return null;
    }

    protected abstract String getPlain(boolean var1, String var2);

    @Override
    public String get(boolean inherit, String key) {
        return this.getInternal(inherit, key, null);
    }

    @Override
    public String get(boolean inherit, boolean required, String key) {
        String value = this.get(inherit, key);
        if (value == null && required) {
            throw new ObjectNotFoundException((Object)"MetaInfo-value", (Object)this.qualifyKey(key));
        }
        return value;
    }

    @Override
    public <T> T getGeneric(boolean inherit, boolean required, String key, ValueType<T> type) {
        String value = this.get(inherit, required, key);
        if (value == null) {
            return null;
        }
        try {
            return (T)type.parse(value);
        }
        catch (Exception e) {
            String expected = type.toString() + " for " + this.qualifyKey(key);
            throw new ObjectMismatchException((Object)value, (Object)expected, (Throwable)e);
        }
    }

    public String getInternal(boolean inherit, String key, MetaInfo stop) {
        AbstractMetaInfo parent;
        String value = this.getPlain(inherit, this.qualifyKey(key));
        if (value == null && inherit && (parent = this.getParent()) != null && parent != stop) {
            value = parent.get(true, key);
        }
        return value;
    }

    protected String qualifyKey(String key) {
        String keyPrefix = this.getKeyPrefix();
        if (keyPrefix.isEmpty() || key == null) {
            return key;
        }
        return keyPrefix + key;
    }

    protected String unqualifyKey(String key) {
        String keyPrefix = this.getKeyPrefix();
        if (keyPrefix.isEmpty()) {
            return key;
        }
        if (key != null && key.startsWith(keyPrefix)) {
            return key.substring(keyPrefix.length());
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        for (String key : this) {
            assert (key != null);
            ++size;
        }
        return size;
    }

    @Override
    public MetaInfo with(String key, String value) {
        return new MetaInfoSingle(this.asParent(), key, value);
    }

    @Override
    public MetaInfo with(Map<String, String> map, String keyPrefix) {
        if (map == null) {
            return this;
        }
        return new MetaInfoMap(map, this.asParent(), keyPrefix);
    }

    @Override
    public MetaInfo with(Properties properties, String keyPrefix) {
        if (properties == null) {
            return this;
        }
        return new MetaInfoProperties(properties, this.asParent(), keyPrefix);
    }

    @Override
    public MetaInfo with(MetaInfos metaValues) {
        String[] values = metaValues.value();
        if (values.length == 0) {
            return this;
        }
        MetaInfoValue value = null;
        for (int i = values.length - 1; i >= 0; --i) {
            value = MetaInfoValue.of(values[i], value);
        }
        MetaInfoValues result = new MetaInfoValues(value, this.asParent());
        assert (result.hasUniqueKeys());
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean sort) {
        StringBuilder sb = new StringBuilder();
        Iterable<String> keys = this;
        if (sort) {
            TreeSet<String> keySet = new TreeSet<String>();
            for (String key : this) {
                keySet.add(key);
            }
            keys = keySet;
        }
        sb.append('{');
        boolean first = true;
        for (String key : keys) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String value = this.get(key);
            sb.append(key);
            sb.append('=');
            sb.append(value);
        }
        sb.append('}');
        return sb.toString();
    }
}

