/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.base.metainfo.impl;

import io.github.mmm.base.exception.RuntimeIoException;
import io.github.mmm.base.metainfo.MetaInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Properties;

public class AppConfigHolder {
    public static final MetaInfo CONFIG;

    private static MetaInfo withApplicationProperties(MetaInfo metaInfo) {
        Path configPath = Paths.get("./config/application.properties", new String[0]);
        if (!Files.exists(configPath, new LinkOption[0])) {
            return metaInfo;
        }
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e);
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(properties);
        return metaInfo.with(map);
    }

    static {
        MetaInfo metaInfo = MetaInfo.empty();
        metaInfo = metaInfo.with(System.getenv());
        metaInfo = AppConfigHolder.withApplicationProperties(metaInfo);
        CONFIG = metaInfo = metaInfo.with(System.getProperties());
    }
}

