/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.base.metainfo.impl;

import java.util.Objects;

public final class MetaInfoValue {
    final String key;
    final String value;
    final MetaInfoValue next;

    public MetaInfoValue(String key, String value) {
        this(key, value, null);
    }

    public MetaInfoValue(String key, String value, MetaInfoValue next) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.key = key;
        this.value = value;
        this.next = next;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public MetaInfoValue getNext() {
        return this.next;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public static MetaInfoValue of(String keyValue, MetaInfoValue next) {
        int i = keyValue.indexOf(61);
        if (i < 0) {
            throw new IllegalArgumentException("Invalid MetaInfo '" + keyValue + "' - has to be in the form '\u00abkey\u00bb=\u00abvalue\u00bb'!");
        }
        String key = keyValue.substring(0, i);
        String value = keyValue.substring(i + 1);
        return new MetaInfoValue(key, value, next);
    }
}

