/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.base.placement;

import io.github.mmm.base.placement.Direction;
import io.github.mmm.base.placement.HorizontalAlignment;
import io.github.mmm.base.placement.Orientation;
import io.github.mmm.base.placement.VerticalAlignment;

public enum Alignment {
    CENTER("c", "center"){

        @Override
        public Alignment getMirrored() {
            return CENTER;
        }
    }
    ,
    TOP("n", "top"){

        @Override
        public Alignment getMirrored() {
            return BOTTOM;
        }
    }
    ,
    BOTTOM("s", "bottom"){

        @Override
        public Alignment getMirrored() {
            return TOP;
        }
    }
    ,
    LEFT("w", "left"){

        @Override
        public Alignment getMirrored() {
            return RIGHT;
        }
    }
    ,
    RIGHT("e", "right"){

        @Override
        public Alignment getMirrored() {
            return LEFT;
        }
    }
    ,
    TOP_LEFT("nw", "top left"){

        @Override
        public Alignment getMirrored() {
            return BOTTOM_RIGHT;
        }
    }
    ,
    TOP_RIGHT("ne", "top right"){

        @Override
        public Alignment getMirrored() {
            return BOTTOM_LEFT;
        }
    }
    ,
    BOTTOM_LEFT("sw", "bottom left"){

        @Override
        public Alignment getMirrored() {
            return TOP_RIGHT;
        }
    }
    ,
    BOTTOM_RIGHT("se", "bottom right"){

        @Override
        public Alignment getMirrored() {
            return TOP_LEFT;
        }
    };

    private final String syntax;
    private final String title;

    private Alignment(String syntax, String title) {
        this.syntax = syntax;
        this.title = title;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public String toString() {
        return this.title;
    }

    public static Alignment fromValue(String value) {
        for (Alignment alignment : Alignment.values()) {
            if (!alignment.syntax.equals(value)) continue;
            return alignment;
        }
        return null;
    }

    public HorizontalAlignment toHorizontalAlignment() {
        if (this == TOP_LEFT || this == LEFT || this == BOTTOM_LEFT) {
            return HorizontalAlignment.LEFT;
        }
        if (this == TOP_RIGHT || this == RIGHT || this == BOTTOM_RIGHT) {
            return HorizontalAlignment.RIGHT;
        }
        return HorizontalAlignment.CENTER;
    }

    public VerticalAlignment toVerticalAlignment() {
        if (this == TOP_LEFT || this == TOP || this == TOP_RIGHT) {
            return VerticalAlignment.TOP;
        }
        if (this == BOTTOM_LEFT || this == BOTTOM || this == BOTTOM_RIGHT) {
            return VerticalAlignment.BOTTOM;
        }
        return VerticalAlignment.CENTER;
    }

    public Alignment toAlignment(Orientation orientation) {
        if (orientation == Orientation.HORIZONTAL) {
            return this.toHorizontalAlignment().toAlignment();
        }
        return this.toVerticalAlignment().toAlignment();
    }

    public abstract Alignment getMirrored();

    public Direction toDirection() {
        switch (this.ordinal()) {
            case 2: {
                return Direction.DOWN;
            }
            case 7: {
                return Direction.DOWN_LEFT;
            }
            case 8: {
                return Direction.DOWN_RIGHT;
            }
            case 0: {
                return null;
            }
            case 3: {
                return Direction.LEFT;
            }
            case 4: {
                return Direction.RIGHT;
            }
            case 1: {
                return Direction.UP;
            }
            case 5: {
                return Direction.UP_LEFT;
            }
            case 6: {
                return Direction.UP_RIGHT;
            }
        }
        throw new IllegalStateException(this.name());
    }

    public static Alignment fromDirection(Direction direction) {
        if (direction == null) {
            return CENTER;
        }
        switch (direction) {
            case RIGHT: {
                return RIGHT;
            }
            case LEFT: {
                return LEFT;
            }
            case UP: {
                return BOTTOM;
            }
            case DOWN: {
                return TOP;
            }
            case DOWN_RIGHT: {
                return BOTTOM_RIGHT;
            }
            case DOWN_LEFT: {
                return BOTTOM_LEFT;
            }
            case UP_RIGHT: {
                return TOP_RIGHT;
            }
            case UP_LEFT: {
                return TOP_LEFT;
            }
        }
        throw new IllegalStateException(direction.name());
    }
}

