/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.base.placement;

import io.github.mmm.base.placement.Alignment;

public enum Direction {
    DOWN("s", "down"),
    RIGHT("e", "right"),
    LEFT("w", "left"),
    UP("n", "up"),
    DOWN_RIGHT("se", "down-right"),
    DOWN_LEFT("sw", "down-left"),
    UP_RIGHT("ne", "up-right"),
    UP_LEFT("nw", "up-left");

    private final String value;
    private final String title;

    private Direction(String value, String title) {
        this.value = value;
        this.title = title;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.title;
    }

    public boolean isRight() {
        return this == RIGHT || this == DOWN_RIGHT || this == UP_RIGHT;
    }

    public boolean isLeft() {
        return this == LEFT || this == DOWN_LEFT || this == UP_LEFT;
    }

    public boolean isDown() {
        return this == DOWN || this == DOWN_RIGHT || this == DOWN_LEFT;
    }

    public boolean isUp() {
        return this == UP || this == UP_RIGHT || this == UP_LEFT;
    }

    public Alignment toAlignment() {
        switch (this.ordinal()) {
            case 3: {
                return Alignment.TOP;
            }
            case 0: {
                return Alignment.BOTTOM;
            }
            case 2: {
                return Alignment.LEFT;
            }
            case 1: {
                return Alignment.RIGHT;
            }
            case 7: {
                return Alignment.TOP_LEFT;
            }
            case 6: {
                return Alignment.TOP_RIGHT;
            }
            case 5: {
                return Alignment.BOTTOM_LEFT;
            }
            case 4: {
                return Alignment.BOTTOM_RIGHT;
            }
        }
        throw new IllegalStateException(this.toString());
    }
}

