/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.base.placement;

import io.github.mmm.base.placement.Alignment;

public enum HorizontalAlignment {
    LEFT("w", "left"),
    RIGHT("e", "right"),
    CENTER("c", "center");

    private final String value;
    private final String title;

    private HorizontalAlignment(String value, String title) {
        this.value = value;
        this.title = title;
    }

    public String getValue() {
        return this.value;
    }

    public Alignment toAlignment() {
        switch (this.ordinal()) {
            case 0: {
                return Alignment.LEFT;
            }
            case 2: {
                return Alignment.CENTER;
            }
            case 1: {
                return Alignment.RIGHT;
            }
        }
        throw new IllegalStateException(this.name());
    }

    public String toString() {
        return this.title;
    }

    public static HorizontalAlignment fromValue(String value) {
        for (HorizontalAlignment alignment : HorizontalAlignment.values()) {
            if (!alignment.value.equals(value)) continue;
            return alignment;
        }
        return null;
    }
}

