/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.base.placement;

import io.github.mmm.base.placement.Alignment;

public enum VerticalAlignment {
    TOP("n", "top"),
    BOTTOM("s", "bottom"),
    CENTER("c", "center");

    private final String value;
    private final String title;

    private VerticalAlignment(String value, String title) {
        this.value = value;
        this.title = title;
    }

    public String getValue() {
        return this.value;
    }

    public Alignment toAlignment() {
        switch (this.ordinal()) {
            case 0: {
                return Alignment.TOP;
            }
            case 2: {
                return Alignment.CENTER;
            }
            case 1: {
                return Alignment.BOTTOM;
            }
        }
        throw new IllegalStateException(this.name());
    }

    public String toString() {
        return this.title;
    }

    public static VerticalAlignment fromValue(String value) {
        for (VerticalAlignment alignment : VerticalAlignment.values()) {
            if (!alignment.value.equals(value)) continue;
            return alignment;
        }
        return null;
    }
}

