/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl;

import io.github.mmm.bean.BeanClass;
import io.github.mmm.bean.BeanFactory;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.factory.impl.proxy.BeanProxyPrototype;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class BeanFactoryImpl
implements BeanFactory {
    private final ClassLoader classLoader;

    public BeanFactoryImpl() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public BeanFactoryImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <B extends WritableBean> B create(Class<B> type, BeanClass beanClass) {
        if (type.isInterface()) {
            BeanProxyPrototype prototype = BeanProxyPrototype.get(type, this);
            return (B)prototype.newInstance().getProxy();
        }
        return null;
    }

    public <B extends WritableBean> B createProxy(InvocationHandler handler, Class<?> ... interfaces) {
        WritableBean bean = (WritableBean)Proxy.newProxyInstance(this.classLoader, interfaces, handler);
        return (B)bean;
    }
}

