/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl;

import io.github.mmm.bean.factory.impl.operation.BeanOperation;
import io.github.mmm.bean.factory.impl.operation.BeanOperationProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanIntrospector {
    private static final Logger LOG = LoggerFactory.getLogger(BeanIntrospector.class);
    private final Class<?> beanType;
    private final Map<String, BeanOperation> propertyMap;
    private final Set<Class<?>> typesVisited;

    public BeanIntrospector(Class<?> beanType) {
        this.beanType = beanType;
        this.propertyMap = new HashMap<String, BeanOperation>();
        this.typesVisited = new HashSet();
    }

    public boolean visitType(Class<?> type) {
        boolean added = this.typesVisited.add(type);
        if (added) {
            LOG.trace("{}: Introspecting type {}", this.beanType, type);
        } else {
            LOG.trace("{}: Already visited type {}", this.beanType, type);
        }
        return added;
    }

    public void add(BeanOperation operation) {
        String propertyName = operation.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (operation instanceof BeanOperationProperty) {
            BeanOperation existing = this.propertyMap.get(propertyName);
            if (!(existing instanceof BeanOperationProperty)) {
                this.propertyMap.put(propertyName, operation);
            }
        } else {
            this.propertyMap.putIfAbsent(propertyName, operation);
        }
    }

    public BeanOperation getPropertyOperation(String name) {
        return this.propertyMap.get(name);
    }

    public Collection<BeanOperation> getPropertyOperations() {
        return new ArrayList<BeanOperation>(this.propertyMap.values());
    }
}

