/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl;

import io.github.mmm.bean.factory.impl.GenericTypeInfoParameter;
import io.github.mmm.bean.factory.impl.GenericTypeInfoReturnType;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class GenericTypeInfo {
    private final Class<?> rawClass;
    protected Type genericType;

    protected GenericTypeInfo(Class<?> rawClass) {
        this(rawClass, null);
    }

    private GenericTypeInfo(Class<?> rawClass, Type genericType) {
        this.rawClass = rawClass;
        this.genericType = genericType;
    }

    public Class<?> getRawClass() {
        return this.rawClass;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public String toString() {
        return this.genericType.getTypeName();
    }

    public static GenericTypeInfo of(Class<?> rawClass, Type genericType) {
        if (genericType == null) {
            genericType = rawClass;
        }
        return new GenericTypeInfo(rawClass, genericType);
    }

    public static GenericTypeInfo ofReturnType(Method method) {
        return new GenericTypeInfoReturnType(method);
    }

    public static GenericTypeInfo ofParameter(Executable executable, int parameterIndex) {
        return new GenericTypeInfoParameter(executable, parameterIndex);
    }

    public static GenericTypeInfo ofGeneric(Type type, Type containingType) {
        Class<?> rawClass = GenericTypeInfo.getRawClass(type, containingType);
        if (rawClass == null) {
            return null;
        }
        return GenericTypeInfo.of(rawClass, type);
    }

    public static Class<?> getRawClass(Type type, Type containingType) {
        return GenericTypeInfo.getRawClass(type, containingType, type);
    }

    private static Class<?> getRawClass(Type type, Type containingType, Type root) {
        WildcardType wType;
        Type[] bounds;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return GenericTypeInfo.getRawClass(pType.getRawType(), containingType, root);
        }
        if (type instanceof WildcardType && (bounds = (wType = (WildcardType)type).getUpperBounds()).length > 0) {
            return GenericTypeInfo.getRawClass(bounds[0], containingType, root);
        }
        return null;
    }
}

