/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class MemoryCache<K, V> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<K, WeakReference<V>> cache = new HashMap<K, WeakReference<V>>(32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Supplier<V> factory) {
        this.lock.lock();
        try {
            WeakReference<Object> weakReference = this.cache.get(key);
            V value = null;
            if (weakReference != null) {
                value = (V)weakReference.get();
            }
            if (value == null) {
                value = factory.get();
                weakReference = new WeakReference<Object>(value);
                this.cache.put(key, weakReference);
            }
            V v = value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }
}

