/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl.mapper;

import io.github.mmm.base.collection.AbstractIterator;
import io.github.mmm.base.exception.DuplicateObjectException;
import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.bean.factory.impl.mapper.BeanTypeSet;
import io.github.mmm.bean.factory.impl.mapper.ClassNameTypeContainer;
import io.github.mmm.bean.mapping.ClassNameMapper;
import io.github.mmm.property.factory.PropertyFactoryManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassNameMapperImpl
implements ClassNameMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNameMapperImpl.class);
    private Map<String, Class<?>> name2typeMap = new HashMap();
    private Map<Class<?>, ClassNameTypeContainer> class2containerMap = new HashMap();

    public ClassNameMapperImpl() {
        this.init();
    }

    void init() {
        for (Class clazz : PropertyFactoryManager.get().getValueTypes()) {
            this.addDatatype(clazz);
        }
        for (Class clazz : BeanTypeSet.INSTANCE.getBeanTypes()) {
            this.addBean(clazz);
        }
    }

    void addDatatype(Class<?> datatype) {
        this.add(new ClassNameTypeContainer(datatype, ClassNameMapper.ClassType.DATATYPE));
    }

    void addBean(Class<?> beanType) {
        this.add(new ClassNameTypeContainer(beanType, ClassNameMapper.ClassType.BEAN));
    }

    void add(ClassNameTypeContainer container) {
        Class<?> mappedClass;
        LOG.debug("Adding class {} for name {} and type {}.", new Object[]{container.javaClass, container.qualifiedName, container.classType});
        ClassNameTypeContainer duplicateContainer = this.class2containerMap.put(container.javaClass, container);
        if (duplicateContainer != null) {
            throw new DuplicateObjectException((Object)container.javaClass.getName(), (Object)container.qualifiedName, (Object)duplicateContainer.qualifiedName);
        }
        Class<?> duplicateClass = this.name2typeMap.put(container.name, container.javaClass);
        if (duplicateClass != null) {
            throw new DuplicateObjectException((Object)container.name, (Object)container.javaClass.getName(), (Object)duplicateClass.getName());
        }
        if (container.name != container.simpleName && (mappedClass = this.name2typeMap.putIfAbsent(container.simpleName, container.javaClass)) != null) {
            duplicateContainer = this.class2containerMap.get(mappedClass);
            Class<?> unmappedClass = container.javaClass;
            if (container.priority > duplicateContainer.priority) {
                this.name2typeMap.put(container.simpleName, container.javaClass);
                unmappedClass = mappedClass;
                mappedClass = container.javaClass;
            }
            LOG.warn("Duplicate simple name {} mapped to class {} and not to {}", new Object[]{container.simpleName, mappedClass, unmappedClass});
        }
    }

    public String getName(Class<?> javaClass) {
        ClassNameTypeContainer container = this.class2containerMap.get(javaClass);
        if (container == null) {
            throw new ObjectNotFoundException((Object)"ClassNameTypeContainer", (Object)javaClass.getName());
        }
        return container.name;
    }

    public String getNameOrQualified(Class<?> javaClass) {
        ClassNameTypeContainer container = this.class2containerMap.get(javaClass);
        if (container == null) {
            return javaClass.getName();
        }
        return container.name;
    }

    public Class<?> getClass(String name) {
        Class<?> javaClass = this.name2typeMap.get(name);
        if (javaClass == null) {
            throw new ObjectNotFoundException((Object)"Class", (Object)name);
        }
        return javaClass;
    }

    public boolean contains(Class<?> javaClass) {
        return this.class2containerMap.containsKey(javaClass);
    }

    public boolean contains(String name) {
        return this.name2typeMap.containsKey(name);
    }

    public Iterator<Class<?>> getClasses(ClassNameMapper.ClassType classType) {
        return new ClassIterator(this.class2containerMap.values().iterator(), classType);
    }

    private static class ClassIterator
    extends AbstractIterator<Class<?>> {
        private final Iterator<ClassNameTypeContainer> it;
        private final ClassNameMapper.ClassType classType;

        private ClassIterator(Iterator<ClassNameTypeContainer> it, ClassNameMapper.ClassType classType) {
            this.it = it;
            this.classType = classType;
            this.findFirst();
        }

        protected Class<?> findNext() {
            while (this.it.hasNext()) {
                ClassNameTypeContainer container = this.it.next();
                if (this.classType != null && this.classType != container.classType) continue;
                return container.javaClass;
            }
            return null;
        }
    }
}

