/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl.mapper;

import io.github.mmm.bean.impl.BeanTypeImpl;
import io.github.mmm.bean.mapping.ClassNameMapper;

public class ClassNameTypeContainer {
    final Class<?> javaClass;
    final String qualifiedName;
    final String simpleName;
    final String name;
    final ClassNameMapper.ClassType classType;
    final int priority;

    public ClassNameTypeContainer(Class<?> javaClass, ClassNameMapper.ClassType classType) {
        this.javaClass = javaClass;
        this.classType = classType;
        this.simpleName = javaClass.getSimpleName();
        this.qualifiedName = classType == ClassNameMapper.ClassType.BEAN ? BeanTypeImpl.getStableName(javaClass) : javaClass.getName();
        if (this.qualifiedName.startsWith("java.")) {
            this.priority = 3;
            this.name = this.simpleName;
        } else if (this.qualifiedName.startsWith("io.github.mmm.")) {
            this.priority = 2;
            this.name = this.simpleName;
        } else {
            this.priority = 1;
            this.name = this.qualifiedName;
        }
    }
}

