/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl.operation;

import io.github.mmm.bean.BeanHelper;
import io.github.mmm.bean.factory.impl.bean.SimpleBeanAliasAccess;
import io.github.mmm.bean.factory.impl.operation.BeanOperationDefaultMethod;
import io.github.mmm.bean.factory.impl.operation.BeanOperationGetter;
import io.github.mmm.bean.factory.impl.operation.BeanOperationProperty;
import io.github.mmm.bean.factory.impl.operation.BeanOperationSetter;
import io.github.mmm.bean.factory.impl.proxy.BeanProxy;
import io.github.mmm.bean.factory.impl.proxy.BeanProxyPrototype;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.factory.PropertyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanOperation {
    private static final Logger LOG = LoggerFactory.getLogger(BeanOperation.class);
    protected static final Object[] NO_ARGS = new Object[0];

    public abstract Object invoke(BeanProxy var1, Object[] var2) throws Throwable;

    protected Object invokeDefaultMethod(BeanProxy proxy, Method method, Object[] args) throws Throwable {
        try {
            return InvocationHandler.invokeDefault(proxy.getProxy(), method, args);
        }
        catch (NoSuchMethodError e) {
            LOG.error("Your Java version is outdated! Please use Java >= 16 to prevent this error! For details see:\nhttps://github.com/m-m-m/bean/issues/4");
            Class<?> returnType = method.getReturnType();
            if (returnType.isPrimitive()) {
                if (Integer.TYPE == returnType) {
                    return 0;
                }
                if (Long.TYPE == returnType) {
                    return 0L;
                }
                if (Double.TYPE == returnType) {
                    return 0.0;
                }
                if (Boolean.TYPE == returnType) {
                    return Boolean.FALSE;
                }
                if (Float.TYPE == returnType) {
                    return Float.valueOf(0.0f);
                }
                if (Character.TYPE == returnType) {
                    return Character.valueOf('\u0000');
                }
                if (Byte.TYPE == returnType) {
                    return (byte)0;
                }
                if (Short.TYPE == returnType) {
                    return (short)0;
                }
            }
            return null;
        }
    }

    public boolean isPropertyRequired() {
        return false;
    }

    public String getPropertyName() {
        return null;
    }

    public WritableProperty<?> createProperty(BeanProxy proxy) {
        return null;
    }

    public void registerAliases(SimpleBeanAliasAccess bean) {
    }

    public static BeanOperation of(Method method, BeanProxyPrototype prototype) {
        String propertyName;
        if (Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        String methodName = method.getName();
        if (method.isDefault()) {
            BeanOperationProperty operation = BeanOperation.createOperationProperty(method, prototype);
            if (operation != null) {
                return operation;
            }
            return new BeanOperationDefaultMethod(method);
        }
        int parameterCount = method.getParameterCount();
        if (parameterCount == 0) {
            BeanOperationProperty operation = BeanOperation.createOperationProperty(method, prototype);
            if (operation != null) {
                return operation;
            }
            String propertyName2 = BeanHelper.getPropertyName4Getter((String)methodName);
            if (propertyName2 != null) {
                return new BeanOperationGetter(propertyName2, method);
            }
        } else if (parameterCount == 1 && (propertyName = BeanHelper.getPropertyName4Setter((String)methodName)) != null) {
            return new BeanOperationSetter(propertyName, method);
        }
        return null;
    }

    private static BeanOperationProperty createOperationProperty(Method method, BeanProxyPrototype prototype) {
        String propertyName = BeanHelper.getPropertyName4Property((Method)method);
        if (propertyName == null) {
            return null;
        }
        PropertyFactory factory = BeanHelper.getPropertyFactory(method.getReturnType());
        if (factory != null) {
            return new BeanOperationProperty(propertyName, method);
        }
        return null;
    }
}

