/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl.operation;

import io.github.mmm.bean.factory.impl.GenericTypeInfo;
import io.github.mmm.bean.factory.impl.operation.BeanOperationOnProperty;
import io.github.mmm.bean.factory.impl.proxy.BeanProxy;
import io.github.mmm.property.WritableProperty;
import java.lang.reflect.Method;

public class BeanOperationGetter
extends BeanOperationOnProperty {
    private final Object defaultResult;

    public BeanOperationGetter(String propertyName, Method method) {
        super(propertyName, method);
        this.defaultResult = BeanOperationGetter.getDefaultResult(method);
    }

    private static Object getDefaultResult(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            if (returnType == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (returnType == Long.TYPE) {
                return 0L;
            }
            if (returnType == Integer.TYPE) {
                return 0;
            }
            if (returnType == Double.TYPE) {
                return 0.0;
            }
            if (returnType == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (returnType == Short.TYPE) {
                return (short)0;
            }
            if (returnType == Byte.TYPE) {
                return (byte)0;
            }
            if (returnType == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    }

    @Override
    public Object invoke(BeanProxy proxy, Object[] args) throws Throwable {
        Object value = proxy.getBean().get(this.propertyName);
        if (value == null) {
            value = this.defaultResult;
        }
        return value;
    }

    @Override
    public WritableProperty<?> createProperty(BeanProxy proxy) {
        return this.createPropertyByValueType(proxy, GenericTypeInfo.ofReturnType(this.method));
    }
}

