/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl.operation;

import io.github.mmm.base.metainfo.MetaInfo;
import io.github.mmm.bean.Mandatory;
import io.github.mmm.bean.PropertyAlias;
import io.github.mmm.bean.factory.impl.GenericTypeInfo;
import io.github.mmm.bean.factory.impl.bean.SimpleBeanAliasAccess;
import io.github.mmm.bean.factory.impl.operation.BeanOperation;
import io.github.mmm.bean.factory.impl.proxy.BeanProxy;
import io.github.mmm.bean.factory.impl.typeinfo.PropertyTypeInfoByProperty;
import io.github.mmm.bean.factory.impl.typeinfo.PropertyTypeInfoByValue;
import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.factory.AbstractSimplePropertyFactory;
import io.github.mmm.property.factory.PropertyFactory;
import io.github.mmm.property.factory.PropertyFactoryManager;
import io.github.mmm.validation.Validator;
import io.github.mmm.validation.main.ValidatorMandatory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;

public abstract class BeanOperationOnProperty
extends BeanOperation {
    protected final String propertyName;
    protected final Method method;
    private MetaInfo metaInfo;

    public BeanOperationOnProperty(String propertyName, Method method) {
        Objects.requireNonNull(propertyName, "propertyName");
        this.propertyName = propertyName;
        this.method = method;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public Method getMethod() {
        return this.method;
    }

    protected WritableProperty<?> createPropertyByPropertyType(BeanProxy proxy, GenericTypeInfo propertyType) {
        PropertyMetadata metadata = this.createMetadata(proxy, null);
        Class<?> propertyClass = propertyType.getRawClass();
        PropertyFactory factory = PropertyFactoryManager.get().getRequiredFactory(propertyClass, null);
        PropertyTypeInfoByProperty typeInfo = null;
        if (factory instanceof AbstractSimplePropertyFactory) {
            return factory.create(this.propertyName, typeInfo, metadata);
        }
        typeInfo = new PropertyTypeInfoByProperty(propertyType, this, proxy);
        WritableProperty property = PropertyFactoryManager.get().create(propertyClass, typeInfo, this.propertyName, metadata);
        return property;
    }

    public WritableProperty<?> createPropertyByValueType(BeanProxy proxy, GenericTypeInfo valueType) {
        PropertyMetadata metadata = this.createMetadata(proxy, null);
        Class<?> valueClass = valueType.getRawClass();
        PropertyFactory factory = PropertyFactoryManager.get().getRequiredFactory(null, valueClass);
        PropertyTypeInfoByValue typeInfo = null;
        if (factory instanceof AbstractSimplePropertyFactory) {
            return factory.create(this.propertyName, typeInfo, metadata);
        }
        typeInfo = new PropertyTypeInfoByValue(valueType, this, proxy);
        WritableProperty property = PropertyFactoryManager.get().create(null, typeInfo, this.propertyName, metadata);
        return property;
    }

    protected PropertyMetadata createMetadata(BeanProxy proxy, PropertyMetadata metadata) {
        PropertyMetadata result;
        if (metadata == null) {
            validator = Validator.none();
            if (this.method.isAnnotationPresent(Mandatory.class)) {
                validator = ValidatorMandatory.get();
            }
            result = PropertyMetadata.of((AttributeReadOnly)proxy.getProxy(), (Validator)validator);
        } else {
            result = metadata.withLock((AttributeReadOnly)proxy.getProxy());
            validator = metadata.getValidator();
            if (!validator.isMandatory() && this.method.isAnnotationPresent(Mandatory.class)) {
                validator = validator.append((Validator)ValidatorMandatory.get());
                result = result.withValidator(validator);
            }
        }
        MetaInfo metaInformation = this.getMetaInfo();
        if (!metaInformation.isEmpty()) {
            assert (result.getMetaInfo().isEmpty());
            result = result.withMetaInfo(metaInformation);
        }
        return result;
    }

    private MetaInfo getMetaInfo() {
        if (this.metaInfo == null) {
            return this.getOrCreateMetaInfo();
        }
        return this.metaInfo;
    }

    private synchronized MetaInfo getOrCreateMetaInfo() {
        if (this.metaInfo == null) {
            this.metaInfo = MetaInfo.empty().with((AnnotatedElement)this.method);
        }
        return this.metaInfo;
    }

    @Override
    public void registerAliases(SimpleBeanAliasAccess bean) {
        PropertyAlias aliasAnnotation = this.method.getAnnotation(PropertyAlias.class);
        if (aliasAnnotation != null) {
            bean.registerAliases(this.getPropertyName(), aliasAnnotation.value());
        }
    }
}

