/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl.proxy;

import io.github.mmm.bean.AbstractBean;
import io.github.mmm.bean.BeanClass;
import io.github.mmm.bean.BeanType;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.factory.impl.BeanFactoryImpl;
import io.github.mmm.bean.factory.impl.bean.SimpleBean;
import io.github.mmm.bean.factory.impl.bean.SimpleVirtualBean;
import io.github.mmm.bean.factory.impl.operation.BeanOperation;
import io.github.mmm.bean.factory.impl.proxy.BeanProxyPrototype;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public abstract class BeanProxy
implements InvocationHandler {
    protected final BeanFactoryImpl beanFactory;
    protected final WritableBean proxy;
    protected final AbstractBean bean;

    public BeanProxy(BeanFactoryImpl beanFactory, WritableBean writable, BeanType beanType, Class<?> ... interfaces) {
        this.proxy = beanFactory.createProxy(this, interfaces);
        this.beanFactory = beanFactory;
        this.bean = beanType instanceof BeanClass ? new SimpleVirtualBean(writable, (BeanClass)beanType) : new SimpleBean(writable, beanType);
    }

    public BeanProxy(BeanFactoryImpl beanFactory, AbstractBean bean, Class<?> ... interfaces) {
        this.proxy = beanFactory.createProxy(this, interfaces);
        this.beanFactory = beanFactory;
        this.bean = bean;
    }

    public abstract BeanProxyPrototype getPrototype();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        Object result = null;
        BeanOperation operation = this.getPrototype().getOperation(method);
        result = operation == null ? method.invoke((Object)this.bean, args) : operation.invoke(this, args);
        return result;
    }

    public WritableBean getProxy() {
        return this.proxy;
    }

    public AbstractBean getBean() {
        return this.bean;
    }
}

