/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl.proxy;

import io.github.mmm.bean.BeanType;
import io.github.mmm.bean.VirtualBean;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.factory.impl.BeanFactoryImpl;
import io.github.mmm.bean.factory.impl.BeanIntrospector;
import io.github.mmm.bean.factory.impl.MemoryCache;
import io.github.mmm.bean.factory.impl.bean.SimpleBeanAliasAccess;
import io.github.mmm.bean.factory.impl.operation.BeanOperation;
import io.github.mmm.bean.factory.impl.operation.BeanOperationProperty;
import io.github.mmm.bean.factory.impl.proxy.BeanProxy;
import io.github.mmm.bean.factory.impl.proxy.BeanProxyBaseMethods;
import io.github.mmm.bean.factory.impl.proxy.BeanProxyInstance;
import io.github.mmm.bean.impl.BeanClassImpl;
import io.github.mmm.bean.impl.BeanTypeImpl;
import io.github.mmm.property.WritableProperty;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BeanProxyPrototype
extends BeanProxy {
    private static final MemoryCache<BeanType, BeanProxyPrototype> cache = new MemoryCache();
    private final Map<Method, BeanOperation> method2operationMap;
    private Collection<BeanOperation> propertyOperations;
    protected final BeanType beanType;
    protected final Class<?>[] interfaces;
    private boolean baseMethodsInitialized;

    public BeanProxyPrototype(BeanFactoryImpl beanFactory, BeanType beanType, Class<?> ... interfaces) {
        super(beanFactory, null, beanType, interfaces);
        this.beanType = beanType;
        this.method2operationMap = new HashMap<Method, BeanOperation>();
        this.interfaces = interfaces;
        this.propertyOperations = this.getPropertyOperations();
        this.initProperties(this);
    }

    void initProperties(BeanProxy beanProxy) {
        for (BeanOperation operation : this.propertyOperations) {
            WritableProperty<?> property = operation.createProperty(beanProxy);
            beanProxy.bean.addProperty(property);
        }
        for (BeanOperation operation : this.propertyOperations) {
            operation.registerAliases((SimpleBeanAliasAccess)beanProxy.bean);
        }
    }

    private Collection<BeanOperation> getPropertyOperations() {
        BeanIntrospector introspector = null;
        for (Class<?> beanInterface : this.interfaces) {
            if (introspector == null) {
                introspector = new BeanIntrospector(beanInterface);
            }
            this.introspect(beanInterface, introspector, true);
        }
        if (introspector == null) {
            return Collections.emptyList();
        }
        return introspector.getPropertyOperations();
    }

    private void introspect(Class<?> beanInterface, BeanIntrospector introspector, boolean primary) {
        if (beanInterface == WritableBean.class || beanInterface == VirtualBean.class) {
            if (!this.baseMethodsInitialized) {
                BeanProxyBaseMethods.INSTANCE.init(this.method2operationMap);
                this.baseMethodsInitialized = true;
            }
            return;
        }
        if (!introspector.visitType(beanInterface)) {
            return;
        }
        for (Method method : beanInterface.getDeclaredMethods()) {
            BeanOperation operation = BeanOperation.of(method, this);
            if (operation == null) continue;
            this.method2operationMap.put(method, operation);
            BeanOperation propertyOperation = introspector.getPropertyOperation(operation.getPropertyName());
            if (propertyOperation instanceof BeanOperationProperty) continue;
            introspector.add(operation);
        }
        for (GenericDeclaration genericDeclaration : beanInterface.getInterfaces()) {
            this.introspect((Class<?>)genericDeclaration, introspector, false);
        }
    }

    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    public BeanType getBeanType() {
        return this.beanType;
    }

    @Override
    public BeanProxyPrototype getPrototype() {
        return this;
    }

    protected BeanOperation getOperation(Method method) {
        return this.method2operationMap.get(method);
    }

    public BeanProxyInstance newInstance() {
        return new BeanProxyInstance(this);
    }

    public static BeanProxyPrototype get(Class<? extends WritableBean> type, BeanFactoryImpl beanFactory) {
        BeanTypeImpl beanType;
        if (VirtualBean.class.isAssignableFrom(type)) {
            beanType = BeanClassImpl.getClass((String)type.getName());
            if (beanType == null) {
                for (Class<?> superType : type.getInterfaces()) {
                    if (!VirtualBean.class.isAssignableFrom(superType) || VirtualBean.class == superType) continue;
                    BeanProxyPrototype.get(superType, beanFactory);
                }
            }
            beanType = BeanClassImpl.asClass(type);
        } else {
            beanType = BeanTypeImpl.asType(type);
        }
        return BeanProxyPrototype.get((BeanType)beanType, beanFactory);
    }

    public static BeanProxyPrototype get(BeanType type, BeanFactoryImpl beanFactory) {
        return cache.get(type, () -> new BeanProxyPrototype(beanFactory, type, type.getJavaClasses()));
    }
}

