/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.impl.typeinfo;

import io.github.mmm.bean.factory.impl.GenericTypeInfo;
import io.github.mmm.bean.factory.impl.operation.BeanOperationOnProperty;
import io.github.mmm.bean.factory.impl.proxy.BeanProxy;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.factory.PropertyTypeInfo;
import io.github.mmm.property.object.WritableSimpleProperty;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractPropertyTypeInfo<V>
implements PropertyTypeInfo<V> {
    private static final Type[] NO_TYPES = new Type[0];
    protected final GenericTypeInfo owner;
    private final BeanOperationOnProperty operation;
    private final BeanProxy proxy;
    protected final Type[] typeArguments;
    protected Class<V> valueClass;
    protected WritableProperty<?> valueProperty;
    protected WritableSimpleProperty<?> keyProperty;

    public AbstractPropertyTypeInfo(GenericTypeInfo genericType, BeanOperationOnProperty operation, BeanProxy proxy) {
        this.owner = genericType;
        this.operation = operation;
        this.proxy = proxy;
        Type type = this.owner.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            this.typeArguments = pType.getActualTypeArguments();
        } else {
            this.typeArguments = NO_TYPES;
        }
    }

    public Class<?> getOwnerClass() {
        return this.owner.getRawClass();
    }

    public Type getOwnerType() {
        return this.owner.getGenericType();
    }

    public Type getTypeArgument(int i) {
        if (i >= 0 && i < this.typeArguments.length) {
            return this.typeArguments[i];
        }
        return null;
    }

    public Class<?> getTypeArgumentClass(int i) {
        if (i >= 0 && i < this.typeArguments.length) {
            return GenericTypeInfo.getRawClass(this.typeArguments[i], this.owner.getRawClass());
        }
        return null;
    }

    WritableProperty<?> getChildProperty(Type childType) {
        GenericTypeInfo childGenericType = GenericTypeInfo.ofGeneric(childType, this.owner.getGenericType());
        if (childGenericType != null) {
            return this.operation.createPropertyByValueType(this.proxy, childGenericType);
        }
        return null;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public WritableProperty<?> getValueProperty() {
        return this.valueProperty;
    }

    public WritableSimpleProperty<?> getKeyProperty() {
        return this.keyProperty;
    }
}

