/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.factory.scanner;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ModuleInfo;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanResult;
import io.github.mmm.bean.AbstractInterface;
import io.github.mmm.bean.VirtualBean;
import io.github.mmm.bean.WritableBean;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanScanner
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BeanScanner.class);
    private static final Set<String> BEAN_INTERFACE_NAMES = Set.of(WritableBean.class.getName(), VirtualBean.class.getName());
    private final ClassLoader classloader;
    private ScanResult scanResult;
    private ModuleExports moduleExports;

    public BeanScanner() {
        this(null);
    }

    public BeanScanner(ClassLoader classloader) {
        ClassGraph classGraph = new ClassGraph();
        if (classloader == null) {
            this.classloader = Thread.currentThread().getContextClassLoader();
        } else {
            this.classloader = classloader;
            classGraph.addClassLoader(classloader);
        }
        this.scanResult = classGraph.enableClassInfo().enableAnnotationInfo().scan();
        this.moduleExports = new ModuleExports();
    }

    public Collection<Class<? extends WritableBean>> findBeanInterfaces() {
        ArrayList<Class<? extends WritableBean>> result = new ArrayList<Class<? extends WritableBean>>();
        for (ClassInfo classInfo : this.scanResult.getAllInterfaces()) {
            Boolean exported;
            if (!classInfo.isPublic() || classInfo.hasAnnotation(AbstractInterface.class) || !this.isBeanInterface(classInfo) || Boolean.FALSE.equals(exported = this.moduleExports.isExported(classInfo))) continue;
            Class beanClass = this.loadClass(classInfo);
            result.add(beanClass);
        }
        return result;
    }

    private boolean isBeanInterface(ClassInfo classInfo) {
        String name = classInfo.getName();
        if (BEAN_INTERFACE_NAMES.contains(name)) {
            return true;
        }
        ClassInfoList interfaces = classInfo.getInterfaces();
        for (ClassInfo interfaceInfo : interfaces) {
            if (!this.isBeanInterface(interfaceInfo)) continue;
            return true;
        }
        return false;
    }

    public Collection<Class<? extends WritableBean>> findBeanClasses() {
        ArrayList<Class<? extends WritableBean>> result = new ArrayList<Class<? extends WritableBean>>();
        for (ClassInfo classInfo : this.scanResult.getClassesImplementing(WritableBean.class.getName())) {
            if (classInfo.isAbstract()) continue;
            this.loadBeanClass(classInfo, result);
        }
        return result;
    }

    private <T> Class<T> loadClass(ClassInfo classInfo) {
        String name = classInfo.getName();
        try {
            Class<?> type = this.classloader.loadClass(name);
            return type;
        }
        catch (Exception e) {
            LOG.warn("Failed to load bean type {}", (Object)name, (Object)e);
            return null;
        }
    }

    private void loadBeanClass(ClassInfo classInfo, Collection<Class<? extends WritableBean>> beanClasses) {
        Class beanClass;
        Boolean exported = this.moduleExports.isExported(classInfo);
        boolean classAdded = false;
        if (!Boolean.FALSE.equals(exported) && (beanClass = this.loadClass(classInfo)) != null && exported != null && this.moduleExports.isExported(beanClass)) {
            beanClasses.add(beanClass);
            classAdded = true;
        }
        if (!classAdded) {
            LOG.debug("Omitting bean type {} that is not visible.", (Object)classInfo.getName());
        }
    }

    @Override
    public void close() {
        if (this.scanResult != null) {
            this.scanResult.close();
            this.scanResult = null;
        }
    }

    private static class ModuleExports {
        private final Map<String, Set<String>> moduleExports = new HashMap<String, Set<String>>();

        private ModuleExports() {
        }

        Boolean isExported(ClassInfo classInfo) {
            ModuleInfo moduleInfo = classInfo.getModuleInfo();
            if (moduleInfo == null) {
                return null;
            }
            ModuleRef moduleRef = moduleInfo.getModuleRef();
            if (moduleRef == null) {
                return null;
            }
            Object descriptor = moduleRef.getDescriptor();
            if (descriptor instanceof ModuleDescriptor) {
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)descriptor;
                String pkg = classInfo.getPackageName();
                return this.isExported(moduleDescriptor, pkg);
            }
            return null;
        }

        boolean isExported(Class<?> type) {
            Module module = type.getModule();
            if (module == null) {
                return true;
            }
            ModuleDescriptor moduleDescriptor = module.getDescriptor();
            if (moduleDescriptor == null) {
                return true;
            }
            return this.isExported(moduleDescriptor, type.getPackageName());
        }

        private boolean isExported(ModuleDescriptor module, String pkg) {
            if (module.isOpen()) {
                return true;
            }
            if (module.isAutomatic()) {
                return true;
            }
            Set<String> exports = this.getExportedPackages(module);
            return exports.contains(pkg);
        }

        private Set<String> getExportedPackages(ModuleDescriptor module) {
            String name = module.name();
            return this.moduleExports.computeIfAbsent(name, n -> this.createExportedPackages(module));
        }

        private Set<String> createExportedPackages(ModuleDescriptor module) {
            HashSet<String> packages = new HashSet<String>();
            for (ModuleDescriptor.Exports export : module.exports()) {
                packages.add(export.source());
            }
            for (ModuleDescriptor.Opens opens : module.opens()) {
                packages.add(opens.source());
            }
            return packages;
        }
    }
}

