/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean;

import io.github.mmm.bean.BeanAliasMap;
import io.github.mmm.bean.BeanHelper;
import io.github.mmm.bean.StandardPropertyBuilders;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.impl.BeanCreator;
import io.github.mmm.bean.impl.alias.AbstractBeanAliasMap;
import io.github.mmm.bean.impl.alias.BeanAliasMapEmpty;
import io.github.mmm.bean.impl.properties.BeanProperties;
import io.github.mmm.bean.impl.properties.BeanPropertiesFactory;
import io.github.mmm.bean.impl.properties.BeanPropertiesReadOnly;
import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.builder.PropertyBuilders;
import io.github.mmm.property.factory.PropertyFactoryManager;
import io.github.mmm.value.ReadablePath;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public abstract class AbstractBean
implements WritableBean {
    private BeanProperties properties;
    private AbstractBeanAliasMap aliases;
    private transient String pathSegment;
    private transient ReadablePath parentPath;
    private AbstractBean readOnly;
    private PropertyBuilders builders;

    public AbstractBean(WritableBean writable) {
        if (writable != null) {
            this.properties = new BeanPropertiesReadOnly(writable);
            this.readOnly = this;
        }
        this.aliases = BeanAliasMapEmpty.INSTANCE;
    }

    @Override
    public String pathSegment() {
        return this.pathSegment;
    }

    @Override
    public void pathSegment(String path) {
        this.requireWritable();
        this.pathSegment = path;
    }

    public ReadablePath parentPath() {
        return this.parentPath;
    }

    public void parentPath(ReadablePath parent) {
        this.requireWritable();
        this.parentPath = parent;
    }

    public String path(boolean fixed) {
        if (fixed) {
            ReadablePath parent = this.parentPath();
            if (parent == null) {
                return this.getType().getSimpleName();
            }
            QualifiedNamePathBuilder builder = new QualifiedNamePathBuilder();
            this.path(builder);
            return builder.toString();
        }
        return WritableBean.super.path(fixed);
    }

    protected boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    protected void requireWritable() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("ReadOnly: " + this.toString());
        }
    }

    protected void requireDynamic() {
        if (!this.isDynamic()) {
            throw new IllegalStateException("Not dynamic: " + this.toString());
        }
    }

    private BeanProperties getBeanProperties() {
        if (this.properties == null) {
            BeanPropertiesFactory factory = (BeanPropertiesFactory)((Object)this.getType());
            this.properties = factory.create(this);
        }
        return this.properties;
    }

    @Override
    public final AbstractBean getReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = this.create(this);
        }
        return this.readOnly;
    }

    @Override
    public AbstractBean newInstance() {
        AbstractBean instance = this.create(null);
        if (this.isDynamic()) {
            for (WritableProperty<?> property : this.getBeanProperties().get()) {
                if (instance.getProperty(property.getName()) != null) continue;
                property = instance.copyProperty(property);
                instance.addProperty(property);
            }
            instance.aliases = this.aliases;
        }
        return instance;
    }

    @Override
    public WritableBean copy() {
        AbstractBean copy = this.newInstance();
        BeanHelper.copy(this, copy);
        return copy;
    }

    public final boolean isReadOnly() {
        return this.readOnly == this;
    }

    protected AbstractBean create(WritableBean writable) {
        try {
            return BeanCreator.doCreate(this.getClass(), writable);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Collection<? extends WritableProperty<?>> getProperties() {
        return this.getBeanProperties().get();
    }

    @Override
    public WritableProperty<?> getProperty(String name) {
        String resolvedAlias;
        WritableProperty<?> property = this.getBeanProperties().get(name);
        if (property == null && (resolvedAlias = this.aliases.getName(name)) != null) {
            property = this.getBeanProperties().get(resolvedAlias);
        }
        return property;
    }

    @Override
    public int getPropertyCount() {
        return this.getBeanProperties().get().size();
    }

    @Override
    public <V> WritableProperty<V> createProperty(String name, Class<V> valueClass) {
        this.requireWritable();
        this.requireDynamic();
        PropertyMetadata metadata = PropertyMetadata.of((AttributeReadOnly)this, null, null);
        WritableProperty property = PropertyFactoryManager.get().create(valueClass, name, metadata);
        property = this.add(property);
        return property;
    }

    @Override
    public <P extends WritableProperty<?>> P addProperty(P property) {
        this.requireWritable();
        this.requireDynamic();
        return this.add(property, AddMode.NORMAL);
    }

    protected <V, P extends WritableProperty<V>> P add(P property) {
        return this.add(property, AddMode.INTERNAL);
    }

    <V, P extends WritableProperty<V>> P add(P property, AddMode mode) {
        PropertyMetadata metadata;
        if (this.readOnly == this) {
            return (P)this.properties.get(property.getName());
        }
        if (mode != AddMode.DIRECT && !this.isLockOwnerInternal((metadata = property.getMetadata()).getLock())) {
            property = this.copyProperty(property);
        }
        if (mode.isAddInstance()) {
            this.getBeanProperties().add(property);
            this.onPropertyAdded(property);
        } else {
            PropertyFunction function = new PropertyFunction(this, property, mode);
            this.getBeanProperties().addIfAbsent(property.getName(), function);
            if (function.result != null) {
                property = function.result;
                this.onPropertyAdded(property);
            }
        }
        return property;
    }

    protected boolean isLockOwnerInternal(AttributeReadOnly lock) {
        return lock == this;
    }

    protected PropertyBuilders add() {
        if (this.builders == null) {
            this.builders = this.createPropertyBuilders();
        }
        return this.builders;
    }

    protected StandardPropertyBuilders createPropertyBuilders() {
        return new StandardPropertyBuilders(this);
    }

    private <V, P extends WritableProperty<V>> P copyProperty(P property) {
        PropertyMetadata metadata = property.getMetadata().withLock((AttributeReadOnly)this);
        return (P)WritableProperty.copy(property, null, (PropertyMetadata)metadata);
    }

    protected void onPropertyAdded(WritableProperty<?> property) {
    }

    protected void registerAlias(String propertyName, String alias) {
        assert (this.getBeanProperties().get(propertyName) != null);
        this.addAlias(propertyName, alias);
    }

    private void addAlias(String propertyName, String alias) {
        assert (this.verifyAlias(alias));
        this.aliases = this.aliases.add(propertyName, alias);
    }

    private boolean verifyAlias(String alias) {
        WritableProperty<?> property = this.getBeanProperties().get(alias);
        if (property == null) {
            return true;
        }
        if (!property.getName().equals(alias)) {
            return true;
        }
        throw new IllegalStateException("Illegal alias '" + alias + "' pointing to an existing property name!");
    }

    protected void registerAliases(String propertyName, String ... propertyAliases) {
        assert (this.getBeanProperties().get(propertyName) != null) : "No property with name '" + propertyName + "' found to map by aliases " + Arrays.toString(propertyAliases);
        for (String alias : propertyAliases) {
            this.addAlias(propertyName, alias);
        }
    }

    @Override
    public BeanAliasMap getAliases() {
        return this.aliases;
    }

    public String toString() {
        return this.doToString();
    }

    protected static boolean isThreadSafe(AbstractBean bean) {
        return bean.isThreadSafe();
    }

    private static class QualifiedNamePathBuilder
    implements ReadablePath.PathBuilder {
        private final StringBuilder buffer = new StringBuilder();

        private QualifiedNamePathBuilder() {
        }

        public void add(ReadablePath path) {
            String segment = null;
            segment = path instanceof AbstractBean ? ((AbstractBean)path).getType().getSimpleName() : path.pathSegment();
            this.add(segment);
        }

        public void add(String segment) {
            if (segment == null || segment.isEmpty()) {
                return;
            }
            if (this.buffer.length() > 0) {
                this.buffer.append('.');
            }
            assert (segment != null && !segment.isEmpty());
            this.buffer.append(segment);
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    static enum AddMode {
        NORMAL,
        INTERNAL,
        DIRECT,
        COPY,
        COPY_WITH_VALUE,
        READ_ONLY;


        public boolean isAddInstance() {
            return this == NORMAL || this == INTERNAL || this == DIRECT;
        }
    }

    private static class PropertyFunction<P extends WritableProperty<?>>
    implements Function<String, WritableProperty<?>> {
        private final P property;
        private final AddMode mode;
        private P result;
        final /* synthetic */ AbstractBean this$0;

        private PropertyFunction(P property, AddMode mode) {
            this.this$0 = var1_1;
            this.property = property;
            this.mode = mode;
        }

        @Override
        public WritableProperty<?> apply(String t) {
            if (this.mode == AddMode.READ_ONLY) {
                this.result = WritableProperty.getReadOnly(this.property);
            } else {
                this.result = this.this$0.copyProperty(this.property);
                if (this.mode == AddMode.COPY_WITH_VALUE && !this.result.isReadOnly()) {
                    this.result.set(this.property.get());
                }
            }
            return this.result;
        }
    }
}

