/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean;

import io.github.mmm.bean.AbstractBean;
import io.github.mmm.bean.BeanClass;
import io.github.mmm.bean.VirtualBean;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.impl.BeanClassImpl;
import io.github.mmm.property.WritableProperty;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractVirtualBean
extends AbstractBean
implements VirtualBean {
    private static final AtomicLong MODIFICATION_SEQUNCE = new AtomicLong(1L);
    private long modificationCounter;
    private long updateCounter;
    private BeanClassImpl type;

    public AbstractVirtualBean() {
        this(null, null);
    }

    public AbstractVirtualBean(WritableBean writable) {
        this(writable, null);
    }

    public AbstractVirtualBean(BeanClass type) {
        this(null, type);
    }

    public AbstractVirtualBean(WritableBean writable, BeanClass type) {
        super(writable);
        if (type == null) {
            Class<?> javaClass = this.getClass();
            this.type = BeanClassImpl.asClass(javaClass);
        } else {
            this.type = (BeanClassImpl)type;
        }
        if (this.type.getPrototype() == null) {
            this.type.setPrototype(this);
        }
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    protected boolean isThreadSafe() {
        return this.isDynamic();
    }

    @Override
    public final boolean isPrototype() {
        return this.type.getPrototype() == this;
    }

    @Override
    public BeanClass getType() {
        return this.type;
    }

    @Override
    protected AbstractBean create(WritableBean writable) {
        AbstractVirtualBean bean = (AbstractVirtualBean)super.create(writable);
        bean.type = this.type;
        return bean;
    }

    @Override
    public WritableProperty<?> getProperty(String name) {
        this.updateProperties();
        return super.getProperty(name);
    }

    @Override
    public int getPropertyCount() {
        this.updateProperties();
        return super.getPropertyCount();
    }

    @Override
    public Collection<? extends WritableProperty<?>> getProperties() {
        this.updateProperties();
        return super.getProperties();
    }

    @Override
    protected void onPropertyAdded(WritableProperty<?> property) {
        super.onPropertyAdded(property);
        if (this.isPrototype()) {
            this.modificationCounter = MODIFICATION_SEQUNCE.incrementAndGet();
        }
    }

    protected void updateProperties() {
        if (this.isPrototype()) {
            long maxCounter = this.updateCounter;
            for (BeanClass beanClass : this.type.getSuperClasses()) {
                AbstractVirtualBean prototype = (AbstractVirtualBean)beanClass.getPrototype();
                if (prototype == null || !prototype.isDynamic()) continue;
                Collection<WritableProperty<?>> properties = prototype.getProperties();
                if (prototype.modificationCounter <= this.updateCounter) continue;
                for (WritableProperty writableProperty : properties) {
                    this.add(writableProperty, AbstractBean.AddMode.COPY_WITH_VALUE);
                }
                if (prototype.modificationCounter <= maxCounter) continue;
                maxCounter = prototype.modificationCounter;
            }
            this.updateCounter = maxCounter;
        } else {
            AbstractVirtualBean prototype = VirtualBean.getPrototype(this);
            if (prototype != null && prototype.isDynamic()) {
                Collection<WritableProperty<?>> properties = prototype.getProperties();
                if (this.updateCounter < prototype.modificationCounter) {
                    for (WritableProperty writableProperty : properties) {
                        this.add(writableProperty, AbstractBean.AddMode.COPY_WITH_VALUE);
                    }
                    this.updateCounter = prototype.modificationCounter;
                }
            }
        }
    }
}

