/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean;

import io.github.mmm.bean.BeanType;
import io.github.mmm.bean.VirtualBean;
import io.github.mmm.bean.impl.BeanClassImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public interface BeanClass
extends BeanType {
    public Collection<BeanClass> getSuperClasses();

    public Class<? extends VirtualBean> getJavaClass();

    public VirtualBean getPrototype();

    default public boolean isSuperclassOf(BeanClass beanClass) {
        return this.isSuperclassOf(beanClass, true, false);
    }

    default public boolean isSuperclassOf(BeanClass beanClass, boolean transitive, boolean equal) {
        if (beanClass == null) {
            return false;
        }
        if (equal && this == beanClass) {
            return true;
        }
        if (transitive) {
            for (BeanClass superClass : beanClass.getSuperClasses()) {
                if (!superClass.isSuperclassOf(beanClass, true, true)) continue;
                return true;
            }
        } else {
            for (BeanClass superClass : beanClass.getSuperClasses()) {
                if (superClass != this) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean isSubclassOf(BeanClass beanClass) {
        if (beanClass == null) {
            return false;
        }
        return beanClass.isSuperclassOf(this);
    }

    default public boolean isSubclassOf(BeanClass beanClass, boolean transitive, boolean equal) {
        if (beanClass == null) {
            return false;
        }
        return beanClass.isSuperclassOf(this, transitive, equal);
    }

    public static BeanClass createVirtual(String packageName, String simpleName, String stableName, BeanClass ... superClasses) {
        List<BeanClass> superClassList = Arrays.asList(superClasses);
        return new BeanClassImpl(superClasses[0].getJavaClass(), superClassList, packageName, stableName, simpleName);
    }
}

