/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean;

import io.github.mmm.bean.ReadableBean;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.property.ReadableProperty;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.factory.PropertyFactory;
import io.github.mmm.property.factory.PropertyFactoryManager;
import io.github.mmm.property.factory.SimplePropertyFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public class BeanHelper {
    public static <B extends WritableBean> void copy(B source, B target) {
        BeanHelper.copyUnsafe(source, target);
    }

    public static void copyUnsafe(ReadableBean source, WritableBean target) {
        for (WritableProperty<?> targetProperty : target.getProperties()) {
            String name;
            ReadableProperty<?> sourceProperty;
            if (targetProperty.isReadOnly() || (sourceProperty = source.getProperty(name = targetProperty.getName())) == null) continue;
            targetProperty.copyValue(sourceProperty);
        }
    }

    public static String getPropertyName4Getter(String getter) {
        return BeanHelper.getCapitalSuffixAfterPrefixes(getter, "get", "has", "is");
    }

    public static String getPropertyName4Setter(String setter) {
        return BeanHelper.getCapitalSuffixAfterPrefix(setter, "set");
    }

    public static String getPropertyName4Property(Method method) {
        if (method.getParameterCount() == 0) {
            String methodName = method.getName();
            char first = methodName.charAt(0);
            if (Character.isUpperCase(first)) {
                return methodName;
            }
            if (methodName.endsWith("Property")) {
                return Character.toUpperCase(first) + methodName.substring(1, methodName.length() - "Property".length());
            }
        }
        return null;
    }

    public static PropertyFactory<?, ?> getPropertyFactory(Class<?> type) {
        if (ReadableProperty.class.isAssignableFrom(type)) {
            Class<?> propertyType = type;
            PropertyFactory factory = PropertyFactoryManager.get().getFactoryForPropertyType(propertyType);
            if (factory == null) {
                if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
                    return new SimplePropertyFactory(propertyType);
                }
                throw new IllegalStateException("Missing PropertyFactory for type: " + type.getName());
            }
            return factory;
        }
        return null;
    }

    private static String getCapitalSuffixAfterPrefixes(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            String suffix = BeanHelper.getCapitalSuffixAfterPrefix(string, prefix);
            if (suffix == null) continue;
            return suffix;
        }
        return null;
    }

    private static String getCapitalSuffixAfterPrefix(String string, String prefix) {
        String suffix;
        if (string.startsWith(prefix) && (suffix = string.substring(prefix.length())).length() > 0 && Character.isUpperCase(suffix.charAt(0))) {
            return suffix;
        }
        return null;
    }

    public static Set<String> getPropertyNames(ReadableBean bean) {
        HashSet<String> names = new HashSet<String>();
        for (ReadableProperty<?> property : bean.getProperties()) {
            names.add(property.getName());
        }
        return names;
    }
}

