/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean;

import io.github.mmm.bean.BeanAliasMap;
import io.github.mmm.bean.BeanType;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.mapping.PropertyIdCollector;
import io.github.mmm.marshall.MarshallableObject;
import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.ReadableProperty;
import io.github.mmm.validation.Validatable;
import io.github.mmm.validation.ValidationResult;
import io.github.mmm.validation.ValidationResultBuilder;
import io.github.mmm.value.ReadablePath;
import java.util.Collection;

public interface ReadableBean
extends Validatable,
MarshallableObject,
AttributeReadOnly,
ReadablePath {
    public static final String SUFFIX_PROPERTY = "Property";

    public ReadableProperty<?> getProperty(String var1);

    public Collection<? extends ReadableProperty<?>> getProperties();

    public int getPropertyCount();

    default public ReadableProperty<?> getRequiredProperty(String name) {
        ReadableProperty<?> property = this.getProperty(name);
        if (property == null) {
            throw new IllegalArgumentException(name);
        }
        return property;
    }

    default public <V> V get(String name) {
        ReadableProperty<?> property = this.getProperty(name);
        if (property == null) {
            return null;
        }
        return (V)property.get();
    }

    public BeanAliasMap getAliases();

    public BeanType getType();

    default public Class<?> getJavaClass() {
        return this.getType().getJavaClass();
    }

    public boolean isDynamic();

    public boolean isPrototype();

    default public boolean isPolymorphic() {
        return false;
    }

    default public ValidationResult validate() {
        ValidationResultBuilder builder = new ValidationResultBuilder();
        for (ReadableProperty<?> property : this.getProperties()) {
            ValidationResult result = property.validate();
            builder.add(result);
        }
        return builder.build(this.getType().getStableName());
    }

    default public boolean isEqual(ReadableBean other) {
        if (other == null) {
            return false;
        }
        if (this.getPropertyCount() != other.getPropertyCount()) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        for (ReadableProperty<?> property : this.getProperties()) {
            String name;
            ReadableProperty<?> otherProperty;
            if (property.isEqual(otherProperty = other.getProperty(name = property.getName()))) continue;
            return false;
        }
        return true;
    }

    public WritableBean copy();

    public WritableBean newInstance();

    default public void mapPropertyIds(PropertyIdCollector mapping) {
    }

    default public boolean doEquals(ReadableBean other) {
        return this == other;
    }

    default public String doToString() {
        StringBuilder sb = new StringBuilder(this.getType().getStableName());
        sb.append("(");
        sb.append("readonly=");
        sb.append(this.isReadOnly());
        sb.append(',');
        if (this.isDynamic()) {
            sb.append("dynamic,");
        }
        this.toString(sb);
        sb.setLength(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    default public void toString(StringBuilder sb) {
        for (ReadableProperty<?> property : this.getProperties()) {
            property.toString(sb);
            sb.append(",");
        }
    }

    public static <B extends ReadableBean> B newInstance(B bean) {
        if (bean == null) {
            return null;
        }
        return (B)bean.newInstance();
    }

    public static <B extends ReadableBean> B copy(B bean) {
        if (bean == null) {
            return null;
        }
        return (B)bean.copy();
    }

    public static <B extends ReadableBean> Class<B> getJavaClass(B bean) {
        return bean.getJavaClass();
    }
}

