/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean;

import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.bean.AbstractInterface;
import io.github.mmm.bean.BeanType;
import io.github.mmm.bean.ReadableBean;
import io.github.mmm.marshall.MarshallingObject;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredState;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.marshall.id.StructuredIdMapping;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.ReadableProperty;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.value.WritablePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@AbstractInterface
public interface WritableBean
extends ReadableBean,
WritablePath,
MarshallingObject,
StructuredIdMappingObject {
    public WritableProperty<?> getProperty(String var1);

    public Collection<? extends WritableProperty<?>> getProperties();

    default public WritableProperty<?> getRequiredProperty(String name) {
        WritableProperty<?> property = this.getProperty(name);
        if (property == null) {
            throw new ObjectNotFoundException((Object)("Property@" + this.getJavaClass().getName()), (Object)name);
        }
        return property;
    }

    default public void set(String name, Object value) {
        WritableProperty<?> property = this.getRequiredProperty(name);
        property.set(value);
    }

    default public void setDynamic(String name, Object value) {
        WritableProperty<?> property = this.getProperty(name);
        if (property == null) {
            if (value == null) {
                return;
            }
            property = this.createProperty(name, value.getClass());
        }
        property.set(value);
    }

    default public <V> void set(String name, V value, Class<V> valueClass) {
        WritableProperty<V> property = this.getOrCreateProperty(name, valueClass);
        property.set(value);
    }

    public <P extends WritableProperty<?>> P addProperty(P var1);

    public <V> WritableProperty<V> createProperty(String var1, Class<V> var2);

    default public <V> WritableProperty<V> getOrCreateProperty(String name, Class<V> valueClass) {
        WritableProperty<?> property = this.getProperty(name);
        if (property != null) {
            if (valueClass.isAssignableFrom(property.getValueClass())) {
                return property;
            }
            throw new IllegalArgumentException("Property '" + name + "' with value class " + property.getValueClass().getName() + " was requested for mismatching value class " + String.valueOf(valueClass));
        }
        return this.createProperty(name, valueClass);
    }

    @Override
    public BeanType getType();

    public WritableBean getReadOnly();

    default public WritableBean read(StructuredReader reader) {
        if (!reader.readStartObject((StructuredIdMappingObject)this) || reader.readEnd()) {
            return this;
        }
        WritableBean result = this;
        int propertyCount = 0;
        while (!reader.readEnd()) {
            String propertyName = reader.readName();
            if ("@type".equals(propertyName)) {
                String type = reader.readValueAsString();
                String stableName = this.getType().getStableName();
                if (propertyCount > 0) {
                    throw new IllegalStateException("Property @type of " + String.valueOf(this.getType()) + " must come first but was " + ++propertyCount + ". property!");
                }
                if (!type.equals(stableName)) {
                    throw new IllegalStateException("@type=" + type + "!=" + stableName);
                }
            } else {
                WritableProperty<?> property = result.getProperty(propertyName);
                if (property == null) {
                    if (this.isDynamic()) {
                        Object value = reader.readValue(true);
                        if (value != null) {
                            Class<?> valueClass = value.getClass();
                            property = this.createProperty(propertyName, valueClass);
                            property.set(value);
                        }
                    } else {
                        reader.skipValue();
                    }
                } else {
                    property.readObject(reader);
                }
            }
            ++propertyCount;
        }
        return result;
    }

    default public void write(StructuredWriter writer) {
        writer.writeStartObject((StructuredIdMappingObject)this);
        if (this.isPolymorphic()) {
            writer.writeName("@type");
            writer.writeValueAsString(this.getType().getStableName());
        }
        for (ReadableProperty readableProperty : this.getProperties()) {
            if (readableProperty.isTransient()) continue;
            String propertyName = readableProperty.getName();
            writer.writeName(propertyName);
            readableProperty.writeObject(writer, (Object)readableProperty);
        }
        writer.writeEnd();
    }

    default public StructuredIdMapping defineIdMapping() {
        return null;
    }

    default public Object asTypeKey() {
        if (this.isDynamic()) {
            return this.getType();
        }
        return this.getType().getJavaClass();
    }

    public String pathSegment();

    public void pathSegment(String var1);

    public static <B extends WritableBean> B getReadOnly(B bean) {
        return (B)bean.getReadOnly();
    }

    public static <B extends WritableBean> B from(WritableProperty<?> property) {
        AttributeReadOnly lock = property.getMetadata().getLock();
        if (lock instanceof WritableBean) {
            return (B)((WritableBean)lock);
        }
        return null;
    }

    public static <B extends WritableBean> List<B> readArray(B template, StructuredReader reader) {
        ArrayList list = new ArrayList();
        WritableBean.readArray(template, reader, list);
        return list;
    }

    public static <B extends WritableBean> void readArray(B template, StructuredReader reader, Collection<B> collection) {
        reader.require(StructuredState.START_ARRAY, true);
        while (!reader.readEndArray()) {
            B bean = ReadableBean.newInstance(template);
            bean.read(reader);
            collection.add(bean);
        }
    }

    public static <B extends WritableBean> void writeArray(Collection<B> beans, StructuredWriter writer) {
        writer.writeStartArray();
        for (WritableBean bean : beans) {
            if (bean == null) {
                writer.writeValueAsNull();
                continue;
            }
            bean.write(writer);
        }
        writer.writeEnd();
    }
}

