/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl;

import io.github.mmm.base.metainfo.MetaInfo;
import io.github.mmm.bean.BeanName;
import io.github.mmm.bean.BeanType;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.impl.properties.BeanPropertiesFactory;
import java.util.Objects;

public abstract class AbstractBeanType
implements BeanType,
BeanPropertiesFactory {
    private final Class<? extends WritableBean> javaClass;
    private final String stableName;
    private MetaInfo metaInfo;

    protected AbstractBeanType(Class<? extends WritableBean> javaClass, String stableName) {
        Objects.requireNonNull(javaClass, "javaClass");
        this.javaClass = javaClass;
        this.stableName = AbstractBeanType.getStableName(javaClass, stableName);
    }

    protected AbstractBeanType(AbstractBeanType template) {
        this.javaClass = template.javaClass;
        this.stableName = template.stableName;
    }

    private static String getStableName(Class<?> javaClass, String stableName) {
        if (stableName != null) {
            return stableName;
        }
        return AbstractBeanType.getStableName(javaClass);
    }

    public static String getStableName(Class<?> javaClass) {
        BeanName name = javaClass.getAnnotation(BeanName.class);
        if (name == null) {
            return javaClass.getSimpleName();
        }
        return name.value();
    }

    @Override
    public Class<? extends WritableBean> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public String getPackageName() {
        return this.javaClass.getPackageName();
    }

    @Override
    public String getSimpleName() {
        return this.javaClass.getSimpleName();
    }

    @Override
    public String getStableName() {
        return this.stableName;
    }

    @Override
    public String getQualifiedName() {
        return this.javaClass.getName();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public MetaInfo getMetaInfo() {
        if (this.metaInfo == null) {
            return this.getOrCreateMetaInfo();
        }
        return this.metaInfo;
    }

    private synchronized MetaInfo getOrCreateMetaInfo() {
        if (this.metaInfo == null) {
            this.metaInfo = MetaInfo.empty().with(this.javaClass);
        }
        return this.metaInfo;
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractBeanType)) {
            return false;
        }
        AbstractBeanType other = (AbstractBeanType)obj;
        return this.javaClass.equals(other.javaClass) && this.stableName.equals(other.stableName);
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

