/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl;

import io.github.mmm.bean.AbstractBean;
import io.github.mmm.bean.AdvancedBean;
import io.github.mmm.bean.BeanClass;
import io.github.mmm.bean.VirtualBean;
import io.github.mmm.bean.impl.AbstractBeanType;
import io.github.mmm.bean.impl.BeanAccessor;
import io.github.mmm.bean.impl.properties.BeanProperties;
import io.github.mmm.bean.impl.properties.BeanPropertiesMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class BeanClassImpl
extends AbstractBeanType
implements BeanClass {
    private static final Map<String, BeanClassImpl> CLASS_MAP = new ConcurrentHashMap<String, BeanClassImpl>();
    private final List<BeanClassImpl> superClassList;
    private final List<BeanClass> superClasses;
    private Class<?>[] javaClasses;
    private final boolean virtual;
    private final String packageName;
    private final String simpleName;
    private final String qualifiedName;
    private VirtualBean prototype;

    public BeanClassImpl(Class<? extends VirtualBean> javaClass, List<BeanClassImpl> superClassList) {
        this(javaClass, superClassList, null);
    }

    public BeanClassImpl(Class<? extends VirtualBean> javaClass, List<BeanClassImpl> superClassList, String stableName) {
        this(javaClass, superClassList, javaClass.getPackageName(), javaClass.getSimpleName(), stableName, false);
    }

    public BeanClassImpl(Class<? extends VirtualBean> javaClass, List<BeanClassImpl> superClassList, String stableName, String simpleName) {
        this(javaClass, superClassList, javaClass.getPackageName(), simpleName, stableName);
    }

    public BeanClassImpl(Class<? extends VirtualBean> javaClass, List<BeanClassImpl> superClassList, String packageName, String stableName, String simpleName) {
        this(javaClass, superClassList, packageName, simpleName, stableName, true);
    }

    private BeanClassImpl(Class<? extends VirtualBean> javaClass, List<BeanClassImpl> superClassList, String packageName, String simpleName, String stableName, boolean virtual) {
        super(javaClass, stableName);
        this.superClassList = superClassList;
        this.superClasses = Collections.unmodifiableList(superClassList);
        this.packageName = packageName == null ? javaClass.getPackageName() : packageName;
        this.simpleName = simpleName == null ? javaClass.getSimpleName() : simpleName;
        this.qualifiedName = this.packageName.isEmpty() ? this.simpleName : this.packageName + "." + this.simpleName;
        if (this.superClassList.isEmpty() || !virtual) {
            this.javaClasses = new Class[]{javaClass};
        } else {
            ArrayList classes = new ArrayList();
            classes.add(javaClass);
            for (BeanClassImpl superClass : superClassList) {
                for (Class<? extends VirtualBean> clazz : superClass.getJavaClasses()) {
                    if (clazz.isAssignableFrom(javaClass)) continue;
                    classes.add(clazz);
                }
            }
            this.javaClasses = classes.toArray(new Class[classes.size()]);
        }
        this.virtual = virtual;
    }

    @Override
    public Class<? extends VirtualBean> getJavaClass() {
        return super.getJavaClass();
    }

    @Override
    public Class<?>[] getJavaClasses() {
        return this.javaClasses;
    }

    public List<BeanClass> getSuperClasses() {
        return this.superClasses;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public VirtualBean getPrototype() {
        return this.prototype;
    }

    public void setPrototype(VirtualBean prototype) {
        if (this.prototype != null) {
            throw new IllegalStateException("Prototype already set!");
        }
        Objects.requireNonNull(prototype, "prototype");
        this.prototype = prototype;
    }

    @Override
    public BeanProperties create(AbstractBean bean) {
        boolean threadSafe = BeanAccessor.isThreadSafe(bean);
        return new BeanPropertiesMap(threadSafe);
    }

    public static BeanClassImpl asClass(Class<? extends VirtualBean> javaClass) {
        return BeanClassImpl.asClass(javaClass, BeanClassImpl::getBeanClass);
    }

    public static BeanClassImpl getClass(String key) {
        return CLASS_MAP.get(key);
    }

    public static BeanClassImpl asClass(Class<? extends VirtualBean> javaClass, Function<Class<?>, BeanClassImpl> factory) {
        String key = javaClass.getName();
        return CLASS_MAP.computeIfAbsent(key, x -> BeanClassImpl.createBeanClass(javaClass, factory));
    }

    private static BeanClassImpl createBeanClass(Class<? extends VirtualBean> javaClass, Function<Class<?>, BeanClassImpl> factory) {
        Class<? extends VirtualBean> superclass;
        List<BeanClassImpl> superClassList = Collections.emptyList();
        if (javaClass.isInterface()) {
            if (javaClass != VirtualBean.class) {
                Class<?>[] interfaces = javaClass.getInterfaces();
                superClassList = new ArrayList<BeanClassImpl>(interfaces.length);
                for (Class<?> superclass2 : interfaces) {
                    if (!VirtualBean.class.isAssignableFrom(superclass2)) continue;
                    BeanClassImpl superBeanClass = factory.apply(superclass2);
                    Objects.requireNonNull(superBeanClass, "factory.apply");
                    superClassList.add(superBeanClass);
                }
            }
        } else if (javaClass != AdvancedBean.class && AdvancedBean.class.isAssignableFrom(superclass = javaClass.getSuperclass())) {
            superClassList = Collections.singletonList(factory.apply(superclass));
        }
        BeanClassImpl beanClass = new BeanClassImpl(javaClass, superClassList);
        return beanClass;
    }

    private static BeanClassImpl getBeanClass(Class<?> javaClass) {
        BeanClassImpl beanClass = CLASS_MAP.get(javaClass.getName());
        if (beanClass == null) {
            throw new IllegalStateException("Super-class " + String.valueOf(javaClass) + " not registered! It seems you forgot to declare a static prototype instance.");
        }
        return beanClass;
    }

    static {
        BeanClassImpl.asClass(VirtualBean.class);
    }
}

