/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl;

import io.github.mmm.bean.AbstractBean;
import io.github.mmm.bean.BeanClass;
import io.github.mmm.bean.BeanFactory;
import io.github.mmm.bean.WritableBean;
import java.lang.reflect.Constructor;

public final class BeanCreator
implements BeanFactory {
    private static final Class<?>[] CONSTRUCTOR_SIGNATURE = new Class[]{WritableBean.class};

    @Override
    public <B extends WritableBean> B create(Class<B> type, BeanClass beanClass) {
        try {
            if (type.isInterface() || beanClass != null) {
                return null;
            }
            return BeanCreator.doCreate(type, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <B extends AbstractBean> B doCreate(Class<B> type, WritableBean writable) throws ReflectiveOperationException {
        try {
            Constructor<B> constructor = type.getConstructor(CONSTRUCTOR_SIGNATURE);
            return (B)((AbstractBean)constructor.newInstance(writable));
        }
        catch (NoSuchMethodException e) {
            if (writable == null) {
                Constructor<B> constructor = type.getConstructor(new Class[0]);
                return (B)((AbstractBean)constructor.newInstance(new Object[0]));
            }
            throw e;
        }
    }
}

