/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl;

import io.github.mmm.base.service.ServiceHelper;
import io.github.mmm.bean.BeanClass;
import io.github.mmm.bean.BeanFactory;
import io.github.mmm.bean.WritableBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public final class BeanFactoryManager
implements BeanFactory {
    public static final BeanFactory INSTANCE = new BeanFactoryManager();
    private final List<BeanFactory> delegates = new ArrayList<BeanFactory>();

    private BeanFactoryManager() {
        ServiceLoader<BeanFactory> loader = ServiceLoader.load(BeanFactory.class);
        ServiceHelper.all(loader, this.delegates);
    }

    @Override
    public <B extends WritableBean> B create(Class<B> type, BeanClass beanClass) {
        Objects.requireNonNull(type, "type");
        try {
            for (BeanFactory delegate : this.delegates) {
                B bean = delegate.create(type, beanClass);
                if (bean == null) continue;
                return bean;
            }
            Object message = "No BeanFactory available for this bean type.";
            if (this.delegates.size() <= 1) {
                message = (String)message + " It seems you did not include dependency mmm-bean-factory or require module io.github.mmm.bean.factory.";
            }
            throw new IllegalStateException((String)message);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create bean of type " + type.getName(), e);
        }
    }
}

