/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl;

import io.github.mmm.bean.AbstractBean;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.impl.AbstractBeanType;
import io.github.mmm.bean.impl.BeanAccessor;
import io.github.mmm.bean.impl.properties.BeanProperties;
import io.github.mmm.bean.impl.properties.BeanPropertiesDynamicArray;
import io.github.mmm.bean.impl.properties.BeanPropertiesMap;
import io.github.mmm.bean.impl.properties.BeanPropertiesStaticArray;
import io.github.mmm.bean.impl.properties.BeanPropertyNames;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanTypeImpl
extends AbstractBeanType {
    private static final Map<String, BeanTypeImpl> CLASS_MAP = new ConcurrentHashMap<String, BeanTypeImpl>();
    private BeanPropertyNames propertyNames;
    private BeanProperties properties;

    protected BeanTypeImpl(Class<? extends WritableBean> javaClass, String stableName) {
        super(javaClass, stableName);
    }

    protected BeanTypeImpl(BeanTypeImpl template) {
        super(template);
    }

    @Override
    public BeanProperties create(AbstractBean bean) {
        BeanProperties result;
        boolean threadSafe = BeanAccessor.isThreadSafe(bean);
        boolean dynamic = bean.isDynamic();
        if (!dynamic && this.properties != null) {
            if (this.propertyNames == null) {
                this.propertyNames = this.properties.createNames();
            }
            result = new BeanPropertiesStaticArray(this.propertyNames);
        } else {
            if (threadSafe) {
                return new BeanPropertiesMap(true);
            }
            int capacity = 8;
            if (this.properties != null) {
                capacity = this.properties.get().size() + 2;
            }
            result = new BeanPropertiesDynamicArray(capacity);
            if (this.properties == null) {
                this.properties = result;
            }
        }
        return result;
    }

    public static BeanTypeImpl asType(Class<? extends WritableBean> javaClass) {
        return BeanTypeImpl.asType(javaClass, null);
    }

    public static BeanTypeImpl asType(Class<? extends WritableBean> javaClass, String stableName) {
        if (javaClass == null) {
            return null;
        }
        return CLASS_MAP.computeIfAbsent(javaClass.getName(), x -> new BeanTypeImpl(javaClass, stableName));
    }
}

