/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl.alias;

import io.github.mmm.bean.impl.alias.AbstractBeanAliasMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanAliasMapMultiple
extends AbstractBeanAliasMap {
    private static final Logger LOG = LoggerFactory.getLogger(BeanAliasMapMultiple.class);
    private final Map<String, String> alias2nameMap = new HashMap<String, String>();
    private final Map<String, List<String>> aliasesMap = new HashMap<String, List<String>>();

    public BeanAliasMapMultiple(String name, String alias) {
        this.register(name, alias);
    }

    private void register(String name, String alias) {
        String duplicate = this.alias2nameMap.put(alias, name);
        if (duplicate != null) {
            LOG.error("Duplicate alias '{}' for name '{}' and '{}'.", new Object[]{alias, duplicate, name});
            if (name.equals(duplicate)) {
                return;
            }
        }
        List aliases = this.aliasesMap.computeIfAbsent(name, x -> new ArrayList());
        aliases.add(alias);
    }

    @Override
    public String getName(String alias) {
        return this.alias2nameMap.get(alias);
    }

    @Override
    public List<String> getAliases(String name) {
        List<String> aliases = this.aliasesMap.get(name);
        if (aliases == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(aliases);
    }

    @Override
    public AbstractBeanAliasMap add(String name, String alias) {
        this.register(name, alias);
        return this;
    }

    public String toString() {
        return "Aliases: " + String.valueOf(this.aliasesMap);
    }
}

