/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl.mapping;

import io.github.mmm.base.exception.DuplicateObjectException;
import io.github.mmm.bean.impl.mapping.PropertyIdMappingMap;
import io.github.mmm.bean.impl.mapping.PropertyIdMappingSimple;
import io.github.mmm.bean.mapping.PropertyIdCollector;
import io.github.mmm.bean.mapping.PropertyIdMapping;
import io.github.mmm.property.ReadableProperty;
import java.util.HashMap;
import java.util.Map;

public class PropertyIdCollectorImpl
implements PropertyIdCollector {
    private int counter;
    private String[] id2nameArray;
    private Map<Integer, String> id2nameMap;

    public PropertyIdCollectorImpl() {
        this(16);
    }

    public PropertyIdCollectorImpl(int capacity) {
        this.id2nameArray = new String[capacity];
    }

    @Override
    public void add(ReadableProperty<?> property, int id) {
        if (id <= 0) {
            throw new IllegalArgumentException(Integer.toString(id));
        }
        Integer idObject = id;
        String name = property.getName();
        if (this.id2nameMap == null && id <= this.id2nameArray.length) {
            if (this.id2nameArray[id - 1] != null) {
                throw new DuplicateObjectException((Object)"property.id", (Object)idObject, (Object)this.id2nameArray[id - 1]);
            }
            this.id2nameArray[id - 1] = name;
        } else {
            String duplicate;
            if (this.id2nameMap == null) {
                this.id2nameMap = new HashMap<Integer, String>(this.id2nameArray.length + 16);
                for (int i = 0; i < this.id2nameArray.length; ++i) {
                    if (this.id2nameArray[i] == null) continue;
                    this.id2nameMap.put(i + 1, this.id2nameArray[i]);
                }
            }
            if ((duplicate = this.id2nameMap.put(idObject, name)) != null) {
                throw new DuplicateObjectException((Object)"property.id", (Object)idObject, (Object)this.id2nameArray[id - 1]);
            }
        }
        if (id > this.counter && id - this.counter < 128) {
            this.counter = id;
        }
    }

    @Override
    public void add(ReadableProperty<?> property) {
        ++this.counter;
        this.add(property, this.counter);
    }

    @Override
    public void addOffset(int offset) {
        this.counter += offset;
    }

    public PropertyIdMapping build() {
        if (this.id2nameMap == null) {
            return new PropertyIdMappingSimple(this.id2nameArray);
        }
        return new PropertyIdMappingMap(this.id2nameMap);
    }
}

