/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl.mapping;

import io.github.mmm.base.exception.DuplicateObjectException;
import io.github.mmm.bean.impl.mapping.AbstractPropertyIdMapping;
import java.util.HashMap;
import java.util.Map;

public class PropertyIdMappingMap
extends AbstractPropertyIdMapping {
    private final Map<String, Integer> name2idMap;
    private final Map<Integer, String> id2nameMap;

    PropertyIdMappingMap(Map<Integer, String> id2nameMap) {
        this.id2nameMap = id2nameMap;
        this.name2idMap = new HashMap<String, Integer>();
        for (Map.Entry<Integer, String> entry : id2nameMap.entrySet()) {
            Integer duplicate = this.name2idMap.put(entry.getValue(), entry.getKey());
            if (duplicate == null) continue;
            throw new DuplicateObjectException((Object)"property.name", (Object)entry.getValue(), (Object)duplicate);
        }
    }

    public PropertyIdMappingMap() {
        this.name2idMap = new HashMap<String, Integer>();
        this.id2nameMap = new HashMap<Integer, String>();
    }

    public void put(int id, String name) {
        Integer i = id;
        this.name2idMap.put(name, i);
        this.id2nameMap.put(i, name);
    }

    @Override
    protected int id(String name) {
        Integer integer = this.name2idMap.get(name);
        if (integer != null) {
            return integer;
        }
        return -1;
    }

    @Override
    public String name(int id) {
        return this.id2nameMap.get(id);
    }
}

