/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl.properties;

import io.github.mmm.bean.impl.properties.BeanProperties;
import io.github.mmm.property.WritableProperty;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class BeanPropertiesDynamicArray
extends BeanProperties {
    private int size;
    private WritableProperty[] propertiesArray;
    private final PropertiesCollection properties;

    public BeanPropertiesDynamicArray(int capacity) {
        if (capacity < 8) {
            capacity = 8;
        }
        this.propertiesArray = new WritableProperty[capacity];
        this.properties = new PropertiesCollection();
    }

    @Override
    public WritableProperty<?> get(String name) {
        int index = this.indexedBinarySearch(name);
        if (index >= 0) {
            return this.propertiesArray[index];
        }
        return null;
    }

    @Override
    public Collection<? extends WritableProperty<?>> get() {
        return this.properties;
    }

    private int indexedBinarySearch(String name) {
        String key = BeanPropertiesDynamicArray.normalize(name);
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            WritableProperty midVal = this.propertiesArray[mid];
            String currentName = BeanPropertiesDynamicArray.normalize(midVal.getName());
            int cmp = currentName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public void add(WritableProperty<?> property) {
        int index = this.indexedBinarySearch(property.getName());
        if (index < 0) {
            this.insert(~index, property);
        } else {
            this.propertiesArray[index] = property;
        }
    }

    private void insert(int index, WritableProperty<?> property) {
        int len;
        assert (index <= this.size);
        WritableProperty[] source = this.propertiesArray;
        WritableProperty[] target = this.propertiesArray;
        int capacity = this.propertiesArray.length;
        if (this.size == capacity) {
            int addCapacity = capacity <= 32 ? 4 : capacity / 8;
            target = new WritableProperty[capacity + addCapacity];
        }
        if (source != target) {
            System.arraycopy(source, 0, target, 0, index);
        }
        if ((len = this.size - index) > 0) {
            System.arraycopy(source, index, target, index + 1, len);
        }
        target[index] = property;
        if (this.propertiesArray != target) {
            this.propertiesArray = target;
        }
        ++this.size;
        for (int i = 0; i < this.size; ++i) {
            if (this.propertiesArray[i] != null) continue;
            throw new IllegalStateException(Arrays.toString(this.propertiesArray));
        }
    }

    @Override
    public WritableProperty<?> addIfAbsent(String name, Function<String, WritableProperty<?>> factory) {
        WritableProperty result;
        int index = this.indexedBinarySearch(name);
        if (index < 0) {
            result = factory.apply(name);
            this.insert(~index, result);
        } else {
            result = this.propertiesArray[index];
        }
        return result;
    }

    private class PropertiesCollection
    extends AbstractCollection<WritableProperty<?>> {
        private PropertiesCollection() {
        }

        @Override
        public int size() {
            return BeanPropertiesDynamicArray.this.size;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<WritableProperty<?>> iterator() {
            return new PropertiesIterator();
        }
    }

    private class PropertiesIterator
    implements Iterator<WritableProperty<?>> {
        private int index;

        private PropertiesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < BeanPropertiesDynamicArray.this.size;
        }

        @Override
        public WritableProperty<?> next() {
            if (this.index >= BeanPropertiesDynamicArray.this.size) {
                throw new NoSuchElementException();
            }
            return BeanPropertiesDynamicArray.this.propertiesArray[this.index++];
        }
    }
}

