/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl.properties;

import io.github.mmm.bean.impl.properties.BeanProperties;
import io.github.mmm.property.WritableProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class BeanPropertiesList
extends BeanProperties {
    private final List<WritableProperty<?>> propertiesList;
    private final Collection<WritableProperty<?>> properties;

    public BeanPropertiesList(boolean threadSafe) {
        this.propertiesList = threadSafe ? new CopyOnWriteArrayList() : new ArrayList();
        this.properties = Collections.unmodifiableCollection(this.propertiesList);
    }

    @Override
    public WritableProperty<?> get(String name) {
        for (WritableProperty<?> property : this.propertiesList) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public Collection<? extends WritableProperty<?>> get() {
        return this.properties;
    }

    private int indexedBinarySearch(String name) {
        String key = BeanPropertiesList.normalize(name);
        int low = 0;
        int high = this.propertiesList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            WritableProperty<?> midVal = this.propertiesList.get(mid);
            String currentName = BeanPropertiesList.normalize(midVal.getName());
            int cmp = currentName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public void add(WritableProperty<?> property) {
        int index = this.indexedBinarySearch(property.getName());
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        this.propertiesList.add(index, property);
    }

    @Override
    public WritableProperty<?> addIfAbsent(String name, Function<String, WritableProperty<?>> factory) {
        int index = this.indexedBinarySearch(name);
        if (index >= 0) {
            return this.propertiesList.get(index);
        }
        WritableProperty<?> property = factory.apply(name);
        this.propertiesList.add(index ^= 0xFFFFFFFF, property);
        return property;
    }
}

