/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.impl.properties;

import io.github.mmm.bean.impl.properties.BeanProperties;
import io.github.mmm.property.WritableProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;

public class BeanPropertiesMap
extends BeanProperties {
    private final Map<String, WritableProperty<?>> propertiesMap;
    private final Collection<WritableProperty<?>> properties;

    public BeanPropertiesMap(boolean threadSafe) {
        this.propertiesMap = threadSafe ? new ConcurrentSkipListMap() : new TreeMap();
        this.properties = Collections.unmodifiableCollection(this.propertiesMap.values());
    }

    @Override
    public WritableProperty<?> get(String name) {
        String key = BeanPropertiesMap.normalize(name);
        return this.propertiesMap.get(key);
    }

    @Override
    public Collection<? extends WritableProperty<?>> get() {
        return this.properties;
    }

    @Override
    public void add(WritableProperty<?> property) {
        String key = BeanPropertiesMap.normalize(property.getName());
        WritableProperty<?> existing = this.propertiesMap.putIfAbsent(key, property);
        if (existing != null) {
            throw new IllegalArgumentException("Duplicate property " + property.getName());
        }
    }

    @Override
    public WritableProperty<?> addIfAbsent(String name, Function<String, WritableProperty<?>> factory) {
        String key = BeanPropertiesMap.normalize(name);
        return this.propertiesMap.computeIfAbsent(key, factory);
    }
}

