/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.property;

import io.github.mmm.bean.BeanFactory;
import io.github.mmm.bean.ReadableBean;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.bean.property.BeanTypeMapper;
import io.github.mmm.bean.property.WritableBeanProperty;
import io.github.mmm.property.Property;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.ReadableProperty;
import io.github.mmm.value.ReadablePath;
import io.github.mmm.value.ReadableValue;
import io.github.mmm.value.converter.TypeMapper;
import java.util.Objects;
import java.util.function.Supplier;

public class BeanProperty<V extends WritableBean>
extends Property<V>
implements WritableBeanProperty<V> {
    private final Class<V> valueClass;
    private V value;
    private TypeMapper<V, ?> typeMapper;

    public BeanProperty(String name, Class<V> valueClass) {
        this(name, valueClass, (PropertyMetadata<Class<V>>)null);
    }

    public BeanProperty(String name, Class<V> valueClass, PropertyMetadata<V> metadata) {
        super(name, metadata);
        this.valueClass = valueClass;
    }

    public BeanProperty(String name, V value) {
        this(name, value, null);
    }

    public BeanProperty(String name, V value, PropertyMetadata<V> metadata) {
        super(name, metadata);
        Objects.requireNonNull(value);
        this.value = value;
        this.valueClass = this.value.getClass();
    }

    public boolean isValueMutable() {
        if (this.value != null) {
            return !this.value.isReadOnly();
        }
        return false;
    }

    protected V doGet() {
        if (this.value == null && this.valueClass != null) {
            this.doSet(BeanFactory.get().create(this.valueClass));
            this.fireEvent();
        }
        return this.value;
    }

    protected void doSet(V newValue) {
        this.value = newValue;
        if (newValue != null) {
            newValue.parentPath((ReadablePath)this);
            this.typeMapper = null;
        }
    }

    public void copyValue(ReadableValue<V> other) {
        WritableBean bean = (WritableBean)other.get();
        if (bean != null) {
            bean = ReadableBean.copy(bean);
        }
        this.set(bean);
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public TypeMapper<V, ?> getTypeMapper() {
        WritableBean bean;
        if (this.typeMapper == null && (bean = (WritableBean)this.get()) != null) {
            this.typeMapper = BeanTypeMapper.of(bean);
        }
        return this.typeMapper;
    }

    protected Supplier<? extends V> createReadOnlyExpression() {
        return () -> {
            WritableBean bean = (WritableBean)this.get();
            if (bean == null) {
                return null;
            }
            return WritableBean.getReadOnly(bean);
        };
    }

    public boolean isEqual(ReadableProperty<?> obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BeanProperty other = (BeanProperty)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (this.value == null || other.value == null) {
            return this.value == other.value;
        }
        return this.value.isEqual((ReadableBean)other.value);
    }
}

