/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.bean.property;

import io.github.mmm.base.lang.Builder;
import io.github.mmm.bean.BeanBuilder;
import io.github.mmm.bean.WritableBean;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.value.converter.CompositeTypeMapper;
import java.util.Iterator;

public class BeanTypeMapper<S extends WritableBean, T>
extends CompositeTypeMapper<S, T> {
    private final WritableProperty<T> property;
    private S template;

    public BeanTypeMapper(WritableProperty<T> property, BeanTypeMapper<S, ?> next, S template) {
        super(property.getName(), next);
        this.property = property;
        this.template = template;
    }

    public Class<? extends S> getSourceType() {
        return this.template.getType().getJavaClass();
    }

    public Class<? extends T> getTargetType() {
        return this.property.getValueClass();
    }

    public T toTarget(S source) {
        return (T)source.get(this.property.getName());
    }

    public Builder<S> sourceBuilder() {
        return BeanBuilder.ofTemplate(this.template);
    }

    public void with(Builder<S> builder, T targetSegment) {
        ((WritableBean)builder.build()).setDynamic(this.suffix, targetSegment);
    }

    public static <B extends WritableBean> BeanTypeMapper<B, ?> of(B bean) {
        return BeanTypeMapper.of(bean, bean.getProperties().iterator());
    }

    private static <B extends WritableBean> BeanTypeMapper<B, ?> of(B bean, Iterator<? extends WritableProperty<?>> propertyIterator) {
        if (propertyIterator.hasNext()) {
            WritableProperty<?> property = propertyIterator.next();
            BeanTypeMapper<B, ?> next = BeanTypeMapper.of(bean, propertyIterator);
            BeanTypeMapper mapper = new BeanTypeMapper(property, next, bean);
            return mapper;
        }
        return null;
    }
}

