/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary;

import io.github.mmm.binary.Binary;
import io.github.mmm.binary.codec.Base64;
import io.github.mmm.binary.codec.BinaryCodec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;

public class BinaryType
implements Binary {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected final byte[] data;

    public BinaryType(byte[] data) {
        if (data == null) {
            Objects.requireNonNull(data, this.getClass().getSimpleName() + ".data");
        }
        if (data.length < this.getMinLength()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".data.length = " + data.length + " < " + this.getMinLength());
        }
        if (data.length > this.getMaxLength()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".data.length = " + data.length + " > " + this.getMaxLength());
        }
        this.data = data;
    }

    public BinaryType(String base64) {
        this(BinaryType.parseBase64(base64));
    }

    protected int getMinLength() {
        return 0;
    }

    protected int getMaxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public byte getDataByte(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index >= this.data.length) {
            return 0;
        }
        return this.data[index];
    }

    @Override
    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    @Override
    public void getData(byte[] buffer, int offset) {
        assert (this.data.length + offset <= buffer.length);
        System.arraycopy(this.data, 0, buffer, offset, this.data.length);
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public String format(BinaryCodec codec) {
        return codec.encode(this.data);
    }

    @Override
    public boolean isZeros() {
        for (byte b : this.data) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public InputStream asStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public void save(OutputStream out) {
        try {
            out.write(this.data);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int hashCode() {
        int hash = 1;
        for (byte b : this.data) {
            hash = 31 * hash + b;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryType other = (BinaryType)obj;
        return Arrays.equals(this.data, other.data);
    }

    public String toString() {
        return this.formatBase64();
    }

    public static byte[] parseHex(String hex) {
        int length = hex.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Hex has odd length: " + length);
        }
        try {
            byte[] bytes = new byte[length / 2];
            int charIndex = 0;
            for (int byteIndex = 0; byteIndex < bytes.length; ++byteIndex) {
                byte high = BinaryType.parseHexChar(hex.charAt(charIndex++));
                byte low = BinaryType.parseHexChar(hex.charAt(charIndex++));
                bytes[byteIndex] = (byte)((high << 4) + low);
            }
            return bytes;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid hexadecimal value: " + hex, e);
        }
    }

    private static byte parseHexChar(char c) {
        int value = Character.digit(c, 16);
        if (value < 0 || value >= 16) {
            throw new IllegalArgumentException("'" + c + "' is not a valid hexadecimal character.");
        }
        return (byte)value;
    }

    public static String formatHex(byte[] data) {
        char[] buffer = new char[data.length * 2];
        int i = 0;
        for (byte b : data) {
            buffer[i++] = HEX[(b & 0xF0) >> 4];
            buffer[i++] = HEX[b & 0xF];
        }
        return new String(buffer);
    }

    public static byte[] parseBase64(String base64) {
        return Base64.DEFAULT.decode(base64);
    }

    public static String formatBase64(byte[] data) {
        return Base64.DEFAULT.encode(data);
    }

    public static byte[] toBytes(long value) {
        long v = value;
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)v;
            v >>= 8;
        }
        return bytes;
    }

    public static byte[] toBytes(int value) {
        int v = value;
        byte[] bytes = new byte[4];
        for (int i = 3; i >= 0; --i) {
            bytes[i] = (byte)v;
            v >>= 8;
        }
        return bytes;
    }

    public static long toLong(byte[] data) {
        assert (data.length <= 8);
        long v = 0L;
        for (byte b : data) {
            v <<= 8;
            v |= (long)(b & 0xFF);
        }
        return v;
    }

    public static long toInt(byte[] data) {
        assert (data.length <= 4);
        int v = 0;
        for (byte b : data) {
            v <<= 8;
            v |= b & 0xFF;
        }
        return v;
    }
}

