/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.binary;

import io.github.mmm.binary.Streamable;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class StreamableBlob
implements Streamable {
    private final Blob blob;

    public StreamableBlob(Blob blob) {
        this.blob = blob;
    }

    public Blob getBlob() {
        return this.blob;
    }

    @Override
    public void save(OutputStream out) {
        try {
            long bytesStreamed = 0L;
            int capacity = 4096;
            for (long bytesRemaining = this.blob.length(); bytesRemaining > 0L; bytesRemaining -= (long)capacity) {
                if (bytesRemaining < (long)capacity) {
                    capacity = (int)bytesRemaining;
                }
                byte[] data = this.blob.getBytes(bytesStreamed, capacity);
                out.write(data);
                bytesStreamed += (long)capacity;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public InputStream asStream() {
        try {
            return this.blob.getBinaryStream();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

